/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class Colors {
    public static final Colors ALICEBLUE = new Colors(0.9411765f, 0.972549f, 1.0f);
    public static final Colors ANTIQUEWHITE = new Colors(0.98039216f, 0.92156863f, 0.84313726f);
    public static final Colors AQUA = new Colors(0.0f, 1.0f, 1.0f);
    public static final Colors AQUAMARINE = new Colors(0.49803922f, 1.0f, 0.83137256f);
    public static final Colors AZURE = new Colors(0.9411765f, 1.0f, 1.0f);
    public static final Colors BEIGE = new Colors(0.9607843f, 0.9607843f, 0.8627451f);
    public static final Colors BISQUE = new Colors(1.0f, 0.89411765f, 0.76862746f);
    public static final Colors BLACK = new Colors(0.0f, 0.0f, 0.0f);
    public static final Colors BLANCHEDALMOND = new Colors(1.0f, 0.92156863f, 0.8039216f);
    public static final Colors BLUE = new Colors(0.0f, 0.0f, 1.0f);
    public static final Colors BLUEVIOLET = new Colors(0.5411765f, 0.16862746f, 0.8862745f);
    public static final Colors BROWN = new Colors(0.64705884f, 0.16470589f, 0.16470589f);
    public static final Colors BURLYWOOD = new Colors(0.87058824f, 0.72156864f, 0.5294118f);
    public static final Colors CADETBLUE = new Colors(0.37254903f, 0.61960787f, 0.627451f);
    public static final Colors CHARTREUSE = new Colors(0.49803922f, 1.0f, 0.0f);
    public static final Colors CHOCOLATE = new Colors(0.8235294f, 0.4117647f, 0.11764706f);
    public static final Colors CORAL = new Colors(1.0f, 0.49803922f, 0.3137255f);
    public static final Colors CORNFLOWERBLUE = new Colors(0.39215687f, 0.58431375f, 0.92941177f);
    public static final Colors CORNSILK = new Colors(1.0f, 0.972549f, 0.8627451f);
    public static final Colors CRIMSON = new Colors(0.8627451f, 0.078431375f, 0.23529412f);
    public static final Colors CYAN = new Colors(0.0f, 1.0f, 1.0f);
    public static final Colors DARKBLUE = new Colors(0.0f, 0.0f, 0.54509807f);
    public static final Colors DARKCYAN = new Colors(0.0f, 0.54509807f, 0.54509807f);
    public static final Colors DARKGOLDENROD = new Colors(0.72156864f, 0.5254902f, 0.043137256f);
    public static final Colors DARKGRAY = new Colors(0.6627451f, 0.6627451f, 0.6627451f);
    public static final Colors DARKGREEN = new Colors(0.0f, 0.39215687f, 0.0f);
    public static final Colors DARKGREY = DARKGRAY;
    public static final Colors DARKKHAKI = new Colors(0.7411765f, 0.7176471f, 0.41960785f);
    public static final Colors DARKMAGENTA = new Colors(0.54509807f, 0.0f, 0.54509807f);
    public static final Colors DARKOLIVEGREEN = new Colors(0.33333334f, 0.41960785f, 0.18431373f);
    public static final Colors DARKORANGE = new Colors(1.0f, 0.54901963f, 0.0f);
    public static final Colors DARKORCHID = new Colors(0.6f, 0.19607843f, 0.8f);
    public static final Colors DARKRED = new Colors(0.54509807f, 0.0f, 0.0f);
    public static final Colors DARKSALMON = new Colors(0.9137255f, 0.5882353f, 0.47843137f);
    public static final Colors DARKSEAGREEN = new Colors(0.56078434f, 0.7372549f, 0.56078434f);
    public static final Colors DARKSLATEBLUE = new Colors(0.28235295f, 0.23921569f, 0.54509807f);
    public static final Colors DARKSLATEGRAY;
    public static final Colors DARKSLATEGREY;
    public static final Colors DARKTURQUOISE;
    public static final Colors DARKVIOLET;
    public static final Colors DEEPPINK;
    public static final Colors DEEPSKYBLUE;
    public static final Colors DIMGRAY;
    public static final Colors DIMGREY;
    public static final Colors DODGERBLUE;
    public static final Colors FIREBRICK;
    public static final Colors FLORALWHITE;
    public static final Colors FORESTGREEN;
    public static final Colors FUCHSIA;
    public static final Colors GAINSBORO;
    public static final Colors GHOSTWHITE;
    public static final Colors GOLD;
    public static final Colors GOLDENROD;
    public static final Colors GRAY;
    public static final Colors GREEN;
    public static final Colors GREENYELLOW;
    public static final Colors GREY;
    public static final Colors HONEYDEW;
    public static final Colors HOTPINK;
    public static final Colors INDIANRED;
    public static final Colors INDIGO;
    public static final Colors IVORY;
    public static final Colors KHAKI;
    public static final Colors LAVENDER;
    public static final Colors LAVENDERBLUSH;
    public static final Colors LAWNGREEN;
    public static final Colors LEMONCHIFFON;
    public static final Colors LIGHTBLUE;
    public static final Colors LIGHTCORAL;
    public static final Colors LIGHTCYAN;
    public static final Colors LIGHTGOLDENRODYELLOW;
    public static final Colors LIGHTGRAY;
    public static final Colors LIGHTGREEN;
    public static final Colors LIGHTGREY;
    public static final Colors LIGHTPINK;
    public static final Colors LIGHTSALMON;
    public static final Colors LIGHTSEAGREEN;
    public static final Colors LIGHTSKYBLUE;
    public static final Colors LIGHTSLATEGRAY;
    public static final Colors LIGHTSLATEGREY;
    public static final Colors LIGHTSTEELBLUE;
    public static final Colors LIGHTYELLOW;
    public static final Colors LIME;
    public static final Colors LIMEGREEN;
    public static final Colors LINEN;
    public static final Colors MAGENTA;
    public static final Colors MAROON;
    public static final Colors MEDIUMAQUAMARINE;
    public static final Colors MEDIUMBLUE;
    public static final Colors MEDIUMORCHID;
    public static final Colors MEDIUMPURPLE;
    public static final Colors MEDIUMSEAGREEN;
    public static final Colors MEDIUMSLATEBLUE;
    public static final Colors MEDIUMSPRINGGREEN;
    public static final Colors MEDIUMTURQUOISE;
    public static final Colors MEDIUMVIOLETRED;
    public static final Colors MIDNIGHTBLUE;
    public static final Colors MINTCREAM;
    public static final Colors MISTYROSE;
    public static final Colors MOCCASIN;
    public static final Colors NAVAJOWHITE;
    public static final Colors NAVY;
    public static final Colors OLDLACE;
    public static final Colors OLIVE;
    public static final Colors OLIVEDRAB;
    public static final Colors ORANGE;
    public static final Colors ORANGERED;
    public static final Colors ORCHID;
    public static final Colors PALEGOLDENROD;
    public static final Colors PALEGREEN;
    public static final Colors PALETURQUOISE;
    public static final Colors PALEVIOLETRED;
    public static final Colors PAPAYAWHIP;
    public static final Colors PEACHPUFF;
    public static final Colors PERU;
    public static final Colors PINK;
    public static final Colors PLUM;
    public static final Colors POWDERBLUE;
    public static final Colors PURPLE;
    public static final Colors RED;
    public static final Colors ROSYBROWN;
    public static final Colors ROYALBLUE;
    public static final Colors SADDLEBROWN;
    public static final Colors SALMON;
    public static final Colors SANDYBROWN;
    public static final Colors SEAGREEN;
    public static final Colors SEASHELL;
    public static final Colors SIENNA;
    public static final Colors SILVER;
    public static final Colors SKYBLUE;
    public static final Colors SLATEBLUE;
    public static final Colors SLATEGRAY;
    public static final Colors SLATEGREY;
    public static final Colors SNOW;
    public static final Colors SPRINGGREEN;
    public static final Colors STEELBLUE;
    public static final Colors TAN;
    public static final Colors TEAL;
    public static final Colors THISTLE;
    public static final Colors TOMATO;
    public static final Colors TRANSPARENT;
    public static final Colors TURQUOISE;
    public static final Colors VIOLET;
    public static final Colors WHEAT;
    public static final Colors WHITE;
    public static final Colors WHITESMOKE;
    public static final Colors YELLOW;
    public static final Colors YELLOWGREEN;
    private static final int PARSE_ALPHA = 3;
    private static final int PARSE_ANGLE = 2;
    private static final int PARSE_COMPONENT = 0;
    private static final int PARSE_PERCENT = 1;
    private final float blue;
    private final float green;
    private final float red;
    private float opacity = 1.0f;
    private Object platformPaint;

    public Colors(double red, double green, double blue, double opacity) {
        if (red < 0.0 || red > 1.0) {
            throw new IllegalArgumentException("Color's red value (" + red + ") must be in the range 0.0-1.0");
        }
        if (green < 0.0 || green > 1.0) {
            throw new IllegalArgumentException("Color's green value (" + green + ") must be in the range 0.0-1.0");
        }
        if (blue < 0.0 || blue > 1.0) {
            throw new IllegalArgumentException("Color's blue value (" + blue + ") must be in the range 0.0-1.0");
        }
        if (opacity < 0.0 || opacity > 1.0) {
            throw new IllegalArgumentException("Color's opacity value (" + opacity + ") must be in the range 0.0-1.0");
        }
        this.red = (float)red;
        this.green = (float)green;
        this.blue = (float)blue;
        this.opacity = (float)opacity;
    }

    private Colors(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static double[] HSBtoRGB(double hue, double saturation, double brightness) {
        double normalizedHue = (hue % 360.0 + 360.0) % 360.0;
        hue = normalizedHue / 360.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (saturation == 0.0) {
            g = b = brightness;
            r = b;
        } else {
            double h = (hue - Math.floor(hue)) * 6.0;
            double f = h - Math.floor(h);
            double p = brightness * (1.0 - saturation);
            double q = brightness * (1.0 - saturation * f);
            double t = brightness * (1.0 - saturation * (1.0 - f));
            switch ((int)h) {
                case 0: {
                    r = brightness;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = brightness;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = brightness;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = brightness;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = brightness;
                    break;
                }
                case 5: {
                    r = brightness;
                    g = p;
                    b = q;
                }
            }
        }
        double[] f = new double[]{r, g, b};
        return f;
    }

    public static double[] RGBtoHSB(double r, double g, double b) {
        double hue;
        double cmin;
        double cmax;
        double[] hsbvals = new double[3];
        double d = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        double d2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        double brightness = cmax;
        double saturation = cmax != 0.0 ? (cmax - cmin) / cmax : 0.0;
        if (saturation == 0.0) {
            hue = 0.0;
        } else {
            double redc = (cmax - r) / (cmax - cmin);
            double greenc = (cmax - g) / (cmax - cmin);
            double bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0 + redc - bluec : 4.0 + greenc - redc);
            if ((hue /= 6.0) < 0.0) {
                hue += 1.0;
            }
        }
        hsbvals[0] = hue * 360.0;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static Colors color(double red, double green, double blue, double opacity) {
        return new Colors(red, green, blue, opacity);
    }

    public static Colors hsb(double hue, double saturation, double brightness, double opacity) {
        Colors.checkSB(saturation, brightness);
        double[] rgb = Colors.HSBtoRGB(hue, saturation, brightness);
        Colors result = new Colors(rgb[0], rgb[1], rgb[2], opacity);
        return result;
    }

    public static Colors rgb(int red, int green, int blue, double opacity) {
        Colors.checkRGB(red, green, blue);
        return new Colors((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0, opacity);
    }

    public static Colors valueOf(String value) {
        if (value == null) {
            throw new NullPointerException("color must be specified");
        }
        return Colors.web(value);
    }

    public static Colors web(String colorString, double opacity) {
        if (colorString == null) {
            throw new NullPointerException("The color components or name must be specified");
        }
        if (colorString.isEmpty()) {
            throw new IllegalArgumentException("Invalid color specification");
        }
        String color = colorString.toLowerCase(Locale.ROOT);
        if (color.startsWith("#")) {
            color = color.substring(1);
        } else if (color.startsWith("0x")) {
            color = color.substring(2);
        } else if (color.startsWith("rgb")) {
            if (color.startsWith("(", 3)) {
                return Colors.parseRGBColor(color, 4, false, opacity);
            }
            if (color.startsWith("a(", 3)) {
                return Colors.parseRGBColor(color, 5, true, opacity);
            }
        } else if (color.startsWith("hsl")) {
            if (color.startsWith("(", 3)) {
                return Colors.parseHSLColor(color, 4, false, opacity);
            }
            if (color.startsWith("a(", 3)) {
                return Colors.parseHSLColor(color, 5, true, opacity);
            }
        } else {
            Colors col = NamedColors.get(color);
            if (col != null) {
                if (opacity == 1.0) {
                    return col;
                }
                return Colors.color(col.red, col.green, col.blue, opacity);
            }
        }
        int len = color.length();
        try {
            if (len == 3) {
                int r = Integer.parseInt(color.substring(0, 1), 16);
                int g = Integer.parseInt(color.substring(1, 2), 16);
                int b = Integer.parseInt(color.substring(2, 3), 16);
                return Colors.color((double)r / 15.0, (double)g / 15.0, (double)b / 15.0, opacity);
            }
            if (len == 4) {
                int r = Integer.parseInt(color.substring(0, 1), 16);
                int g = Integer.parseInt(color.substring(1, 2), 16);
                int b = Integer.parseInt(color.substring(2, 3), 16);
                int a = Integer.parseInt(color.substring(3, 4), 16);
                return Colors.color((double)r / 15.0, (double)g / 15.0, (double)b / 15.0, opacity * (double)a / 15.0);
            }
            if (len == 6) {
                int r = Integer.parseInt(color.substring(0, 2), 16);
                int g = Integer.parseInt(color.substring(2, 4), 16);
                int b = Integer.parseInt(color.substring(4, 6), 16);
                return Colors.rgb(r, g, b, opacity);
            }
            if (len == 8) {
                int r = Integer.parseInt(color.substring(0, 2), 16);
                int g = Integer.parseInt(color.substring(2, 4), 16);
                int b = Integer.parseInt(color.substring(4, 6), 16);
                int a = Integer.parseInt(color.substring(6, 8), 16);
                return Colors.rgb(r, g, b, opacity * (double)a / 255.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    public static Colors web(String colorString) {
        return Colors.web(colorString, 1.0);
    }

    private static void checkRGB(int red, int green, int blue) {
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException("Color.rgb's red parameter (" + red + ") expects color values 0-255");
        }
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException("Color.rgb's green parameter (" + green + ") expects color values 0-255");
        }
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Color.rgb's blue parameter (" + blue + ") expects color values 0-255");
        }
    }

    private static void checkSB(double saturation, double brightness) {
        if (saturation < 0.0 || saturation > 1.0) {
            throw new IllegalArgumentException("Color.hsb's saturation parameter (" + saturation + ") expects values 0.0-1.0");
        }
        if (brightness < 0.0 || brightness > 1.0) {
            throw new IllegalArgumentException("Color.hsb's brightness parameter (" + brightness + ") expects values 0.0-1.0");
        }
    }

    private static double parseComponent(String color, int off, int end, int type) {
        if ((color = color.substring(off, end).trim()).endsWith("%")) {
            if (type > 1) {
                throw new IllegalArgumentException("Invalid color specification");
            }
            type = 1;
            color = color.substring(0, color.length() - 1).trim();
        } else if (type == 1) {
            throw new IllegalArgumentException("Invalid color specification");
        }
        double c = type == 0 ? (double)Integer.parseInt(color) : Double.parseDouble(color);
        switch (type) {
            case 3: {
                return c < 0.0 ? 0.0 : (c > 1.0 ? 1.0 : c);
            }
            case 1: {
                return c <= 0.0 ? 0.0 : (c >= 100.0 ? 1.0 : c / 100.0);
            }
            case 0: {
                return c <= 0.0 ? 0.0 : (c >= 255.0 ? 1.0 : c / 255.0);
            }
            case 2: {
                return c < 0.0 ? c % 360.0 + 360.0 : (c > 360.0 ? c % 360.0 : c);
            }
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static Colors parseHSLColor(String color, int hoff, boolean hasAlpha, double a) {
        try {
            int aend;
            int lend;
            int send;
            int hend = color.indexOf(44, hoff);
            int n = send = hend < 0 ? -1 : color.indexOf(44, hend + 1);
            int n2 = send < 0 ? -1 : (lend = color.indexOf(hasAlpha ? 44 : 41, send + 1));
            int n3 = hasAlpha ? (lend < 0 ? -1 : color.indexOf(41, lend + 1)) : (aend = lend);
            if (aend >= 0) {
                double h = Colors.parseComponent(color, hoff, hend, 2);
                double s = Colors.parseComponent(color, hend + 1, send, 1);
                double l = Colors.parseComponent(color, send + 1, lend, 1);
                if (hasAlpha) {
                    a *= Colors.parseComponent(color, lend + 1, aend, 3);
                }
                return Colors.hsb(h, s, l, a);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static Colors parseRGBColor(String color, int roff, boolean hasAlpha, double a) {
        try {
            int aend;
            int bend;
            int gend;
            int rend = color.indexOf(44, roff);
            int n = gend = rend < 0 ? -1 : color.indexOf(44, rend + 1);
            int n2 = gend < 0 ? -1 : (bend = color.indexOf(hasAlpha ? 44 : 41, gend + 1));
            int n3 = hasAlpha ? (bend < 0 ? -1 : color.indexOf(41, bend + 1)) : (aend = bend);
            if (aend >= 0) {
                double r = Colors.parseComponent(color, roff, rend, 0);
                double g = Colors.parseComponent(color, rend + 1, gend, 0);
                double b = Colors.parseComponent(color, gend + 1, bend, 0);
                if (hasAlpha) {
                    a *= Colors.parseComponent(color, bend + 1, aend, 3);
                }
                return new Colors(r, g, b, a);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static int to32BitInteger(int red, int green, int blue, int alpha) {
        int i = red;
        i <<= 8;
        i |= green;
        i <<= 8;
        i |= blue;
        i <<= 8;
        return i |= alpha;
    }

    public double getBlue() {
        return this.blue;
    }

    public double getBrightness() {
        return Colors.RGBtoHSB(this.red, this.green, this.blue)[2];
    }

    public double getGreen() {
        return this.green;
    }

    public double getHue() {
        return Colors.RGBtoHSB(this.red, this.green, this.blue)[0];
    }

    public double getOpacity() {
        return this.opacity;
    }

    public double getRed() {
        return this.red;
    }

    public double getSaturation() {
        return Colors.RGBtoHSB(this.red, this.green, this.blue)[1];
    }

    public int hashCode() {
        int r = (int)Math.round((double)this.red * 255.0);
        int g = (int)Math.round((double)this.green * 255.0);
        int b = (int)Math.round((double)this.blue * 255.0);
        int a = (int)Math.round((double)this.opacity * 255.0);
        return Colors.to32BitInteger(r, g, b, a);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Colors) {
            Colors other = (Colors)obj;
            return this.red == other.red && this.green == other.green && this.blue == other.blue && this.opacity == other.opacity;
        }
        return false;
    }

    public String toString() {
        int r = (int)Math.round((double)this.red * 255.0);
        int g = (int)Math.round((double)this.green * 255.0);
        int b = (int)Math.round((double)this.blue * 255.0);
        int o = (int)Math.round((double)this.opacity * 255.0);
        return String.format("0x%02x%02x%02x%02x", r, g, b, o);
    }

    public Colors invert() {
        return Colors.color(1.0 - (double)this.red, 1.0 - (double)this.green, 1.0 - (double)this.blue, this.opacity);
    }

    public boolean isOpaque() {
        return this.opacity >= 1.0f;
    }

    static {
        DARKSLATEGREY = DARKSLATEGRAY = new Colors(0.18431373f, 0.30980393f, 0.30980393f);
        DARKTURQUOISE = new Colors(0.0f, 0.80784315f, 0.81960785f);
        DARKVIOLET = new Colors(0.5803922f, 0.0f, 0.827451f);
        DEEPPINK = new Colors(1.0f, 0.078431375f, 0.5764706f);
        DEEPSKYBLUE = new Colors(0.0f, 0.7490196f, 1.0f);
        DIMGREY = DIMGRAY = new Colors(0.4117647f, 0.4117647f, 0.4117647f);
        DODGERBLUE = new Colors(0.11764706f, 0.5647059f, 1.0f);
        FIREBRICK = new Colors(0.69803923f, 0.13333334f, 0.13333334f);
        FLORALWHITE = new Colors(1.0f, 0.98039216f, 0.9411765f);
        FORESTGREEN = new Colors(0.13333334f, 0.54509807f, 0.13333334f);
        FUCHSIA = new Colors(1.0f, 0.0f, 1.0f);
        GAINSBORO = new Colors(0.8627451f, 0.8627451f, 0.8627451f);
        GHOSTWHITE = new Colors(0.972549f, 0.972549f, 1.0f);
        GOLD = new Colors(1.0f, 0.84313726f, 0.0f);
        GOLDENROD = new Colors(0.85490197f, 0.64705884f, 0.1254902f);
        GRAY = new Colors(0.5019608f, 0.5019608f, 0.5019608f);
        GREEN = new Colors(0.0f, 0.5019608f, 0.0f);
        GREENYELLOW = new Colors(0.6784314f, 1.0f, 0.18431373f);
        GREY = GRAY;
        HONEYDEW = new Colors(0.9411765f, 1.0f, 0.9411765f);
        HOTPINK = new Colors(1.0f, 0.4117647f, 0.7058824f);
        INDIANRED = new Colors(0.8039216f, 0.36078432f, 0.36078432f);
        INDIGO = new Colors(0.29411766f, 0.0f, 0.50980395f);
        IVORY = new Colors(1.0f, 1.0f, 0.9411765f);
        KHAKI = new Colors(0.9411765f, 0.9019608f, 0.54901963f);
        LAVENDER = new Colors(0.9019608f, 0.9019608f, 0.98039216f);
        LAVENDERBLUSH = new Colors(1.0f, 0.9411765f, 0.9607843f);
        LAWNGREEN = new Colors(0.4862745f, 0.9882353f, 0.0f);
        LEMONCHIFFON = new Colors(1.0f, 0.98039216f, 0.8039216f);
        LIGHTBLUE = new Colors(0.6784314f, 0.84705883f, 0.9019608f);
        LIGHTCORAL = new Colors(0.9411765f, 0.5019608f, 0.5019608f);
        LIGHTCYAN = new Colors(0.8784314f, 1.0f, 1.0f);
        LIGHTGOLDENRODYELLOW = new Colors(0.98039216f, 0.98039216f, 0.8235294f);
        LIGHTGRAY = new Colors(0.827451f, 0.827451f, 0.827451f);
        LIGHTGREEN = new Colors(0.5647059f, 0.93333334f, 0.5647059f);
        LIGHTGREY = LIGHTGRAY;
        LIGHTPINK = new Colors(1.0f, 0.7137255f, 0.75686276f);
        LIGHTSALMON = new Colors(1.0f, 0.627451f, 0.47843137f);
        LIGHTSEAGREEN = new Colors(0.1254902f, 0.69803923f, 0.6666667f);
        LIGHTSKYBLUE = new Colors(0.5294118f, 0.80784315f, 0.98039216f);
        LIGHTSLATEGREY = LIGHTSLATEGRAY = new Colors(0.46666667f, 0.53333336f, 0.6f);
        LIGHTSTEELBLUE = new Colors(0.6901961f, 0.76862746f, 0.87058824f);
        LIGHTYELLOW = new Colors(1.0f, 1.0f, 0.8784314f);
        LIME = new Colors(0.0f, 1.0f, 0.0f);
        LIMEGREEN = new Colors(0.19607843f, 0.8039216f, 0.19607843f);
        LINEN = new Colors(0.98039216f, 0.9411765f, 0.9019608f);
        MAGENTA = new Colors(1.0f, 0.0f, 1.0f);
        MAROON = new Colors(0.5019608f, 0.0f, 0.0f);
        MEDIUMAQUAMARINE = new Colors(0.4f, 0.8039216f, 0.6666667f);
        MEDIUMBLUE = new Colors(0.0f, 0.0f, 0.8039216f);
        MEDIUMORCHID = new Colors(0.7294118f, 0.33333334f, 0.827451f);
        MEDIUMPURPLE = new Colors(0.5764706f, 0.4392157f, 0.85882354f);
        MEDIUMSEAGREEN = new Colors(0.23529412f, 0.7019608f, 0.44313726f);
        MEDIUMSLATEBLUE = new Colors(0.48235294f, 0.40784314f, 0.93333334f);
        MEDIUMSPRINGGREEN = new Colors(0.0f, 0.98039216f, 0.6039216f);
        MEDIUMTURQUOISE = new Colors(0.28235295f, 0.81960785f, 0.8f);
        MEDIUMVIOLETRED = new Colors(0.78039217f, 0.08235294f, 0.52156866f);
        MIDNIGHTBLUE = new Colors(0.09803922f, 0.09803922f, 0.4392157f);
        MINTCREAM = new Colors(0.9607843f, 1.0f, 0.98039216f);
        MISTYROSE = new Colors(1.0f, 0.89411765f, 0.88235295f);
        MOCCASIN = new Colors(1.0f, 0.89411765f, 0.70980394f);
        NAVAJOWHITE = new Colors(1.0f, 0.87058824f, 0.6784314f);
        NAVY = new Colors(0.0f, 0.0f, 0.5019608f);
        OLDLACE = new Colors(0.99215686f, 0.9607843f, 0.9019608f);
        OLIVE = new Colors(0.5019608f, 0.5019608f, 0.0f);
        OLIVEDRAB = new Colors(0.41960785f, 0.5568628f, 0.13725491f);
        ORANGE = new Colors(1.0f, 0.64705884f, 0.0f);
        ORANGERED = new Colors(1.0f, 0.27058825f, 0.0f);
        ORCHID = new Colors(0.85490197f, 0.4392157f, 0.8392157f);
        PALEGOLDENROD = new Colors(0.93333334f, 0.9098039f, 0.6666667f);
        PALEGREEN = new Colors(0.59607846f, 0.9843137f, 0.59607846f);
        PALETURQUOISE = new Colors(0.6862745f, 0.93333334f, 0.93333334f);
        PALEVIOLETRED = new Colors(0.85882354f, 0.4392157f, 0.5764706f);
        PAPAYAWHIP = new Colors(1.0f, 0.9372549f, 0.8352941f);
        PEACHPUFF = new Colors(1.0f, 0.85490197f, 0.7254902f);
        PERU = new Colors(0.8039216f, 0.52156866f, 0.24705882f);
        PINK = new Colors(1.0f, 0.7529412f, 0.79607844f);
        PLUM = new Colors(0.8666667f, 0.627451f, 0.8666667f);
        POWDERBLUE = new Colors(0.6901961f, 0.8784314f, 0.9019608f);
        PURPLE = new Colors(0.5019608f, 0.0f, 0.5019608f);
        RED = new Colors(1.0f, 0.0f, 0.0f);
        ROSYBROWN = new Colors(0.7372549f, 0.56078434f, 0.56078434f);
        ROYALBLUE = new Colors(0.25490198f, 0.4117647f, 0.88235295f);
        SADDLEBROWN = new Colors(0.54509807f, 0.27058825f, 0.07450981f);
        SALMON = new Colors(0.98039216f, 0.5019608f, 0.44705883f);
        SANDYBROWN = new Colors(0.95686275f, 0.6431373f, 0.3764706f);
        SEAGREEN = new Colors(0.18039216f, 0.54509807f, 0.34117648f);
        SEASHELL = new Colors(1.0f, 0.9607843f, 0.93333334f);
        SIENNA = new Colors(0.627451f, 0.32156864f, 0.1764706f);
        SILVER = new Colors(0.7529412f, 0.7529412f, 0.7529412f);
        SKYBLUE = new Colors(0.5294118f, 0.80784315f, 0.92156863f);
        SLATEBLUE = new Colors(0.41568628f, 0.3529412f, 0.8039216f);
        SLATEGREY = SLATEGRAY = new Colors(0.4392157f, 0.5019608f, 0.5647059f);
        SNOW = new Colors(1.0f, 0.98039216f, 0.98039216f);
        SPRINGGREEN = new Colors(0.0f, 1.0f, 0.49803922f);
        STEELBLUE = new Colors(0.27450982f, 0.50980395f, 0.7058824f);
        TAN = new Colors(0.8235294f, 0.7058824f, 0.54901963f);
        TEAL = new Colors(0.0f, 0.5019608f, 0.5019608f);
        THISTLE = new Colors(0.84705883f, 0.7490196f, 0.84705883f);
        TOMATO = new Colors(1.0f, 0.3882353f, 0.2784314f);
        TRANSPARENT = new Colors(0.0, 0.0, 0.0, 0.0);
        TURQUOISE = new Colors(0.2509804f, 0.8784314f, 0.8156863f);
        VIOLET = new Colors(0.93333334f, 0.50980395f, 0.93333334f);
        WHEAT = new Colors(0.9607843f, 0.87058824f, 0.7019608f);
        WHITE = new Colors(1.0f, 1.0f, 1.0f);
        WHITESMOKE = new Colors(0.9607843f, 0.9607843f, 0.9607843f);
        YELLOW = new Colors(1.0f, 1.0f, 0.0f);
        YELLOWGREEN = new Colors(0.6039216f, 0.8039216f, 0.19607843f);
    }

    private static final class NamedColors {
        private static final Map<String, Colors> namedColors = NamedColors.createNamedColors();

        private NamedColors() {
        }

        private static Map<String, Colors> createNamedColors() {
            HashMap<String, Colors> colors = new HashMap<String, Colors>(256);
            colors.put("aliceblue", ALICEBLUE);
            colors.put("antiquewhite", ANTIQUEWHITE);
            colors.put("aqua", AQUA);
            colors.put("aquamarine", AQUAMARINE);
            colors.put("azure", AZURE);
            colors.put("beige", BEIGE);
            colors.put("bisque", BISQUE);
            colors.put("black", BLACK);
            colors.put("blanchedalmond", BLANCHEDALMOND);
            colors.put("blue", BLUE);
            colors.put("blueviolet", BLUEVIOLET);
            colors.put("brown", BROWN);
            colors.put("burlywood", BURLYWOOD);
            colors.put("cadetblue", CADETBLUE);
            colors.put("chartreuse", CHARTREUSE);
            colors.put("chocolate", CHOCOLATE);
            colors.put("coral", CORAL);
            colors.put("cornflowerblue", CORNFLOWERBLUE);
            colors.put("cornsilk", CORNSILK);
            colors.put("crimson", CRIMSON);
            colors.put("cyan", CYAN);
            colors.put("darkblue", DARKBLUE);
            colors.put("darkcyan", DARKCYAN);
            colors.put("darkgoldenrod", DARKGOLDENROD);
            colors.put("darkgray", DARKGRAY);
            colors.put("darkgreen", DARKGREEN);
            colors.put("darkgrey", DARKGREY);
            colors.put("darkkhaki", DARKKHAKI);
            colors.put("darkmagenta", DARKMAGENTA);
            colors.put("darkolivegreen", DARKOLIVEGREEN);
            colors.put("darkorange", DARKORANGE);
            colors.put("darkorchid", DARKORCHID);
            colors.put("darkred", DARKRED);
            colors.put("darksalmon", DARKSALMON);
            colors.put("darkseagreen", DARKSEAGREEN);
            colors.put("darkslateblue", DARKSLATEBLUE);
            colors.put("darkslategray", DARKSLATEGRAY);
            colors.put("darkslategrey", DARKSLATEGREY);
            colors.put("darkturquoise", DARKTURQUOISE);
            colors.put("darkviolet", DARKVIOLET);
            colors.put("deeppink", DEEPPINK);
            colors.put("deepskyblue", DEEPSKYBLUE);
            colors.put("dimgray", DIMGRAY);
            colors.put("dimgrey", DIMGREY);
            colors.put("dodgerblue", DODGERBLUE);
            colors.put("firebrick", FIREBRICK);
            colors.put("floralwhite", FLORALWHITE);
            colors.put("forestgreen", FORESTGREEN);
            colors.put("fuchsia", FUCHSIA);
            colors.put("gainsboro", GAINSBORO);
            colors.put("ghostwhite", GHOSTWHITE);
            colors.put("gold", GOLD);
            colors.put("goldenrod", GOLDENROD);
            colors.put("gray", GRAY);
            colors.put("green", GREEN);
            colors.put("greenyellow", GREENYELLOW);
            colors.put("grey", GREY);
            colors.put("honeydew", HONEYDEW);
            colors.put("hotpink", HOTPINK);
            colors.put("indianred", INDIANRED);
            colors.put("indigo", INDIGO);
            colors.put("ivory", IVORY);
            colors.put("khaki", KHAKI);
            colors.put("lavender", LAVENDER);
            colors.put("lavenderblush", LAVENDERBLUSH);
            colors.put("lawngreen", LAWNGREEN);
            colors.put("lemonchiffon", LEMONCHIFFON);
            colors.put("lightblue", LIGHTBLUE);
            colors.put("lightcoral", LIGHTCORAL);
            colors.put("lightcyan", LIGHTCYAN);
            colors.put("lightgoldenrodyellow", LIGHTGOLDENRODYELLOW);
            colors.put("lightgray", LIGHTGRAY);
            colors.put("lightgreen", LIGHTGREEN);
            colors.put("lightgrey", LIGHTGREY);
            colors.put("lightpink", LIGHTPINK);
            colors.put("lightsalmon", LIGHTSALMON);
            colors.put("lightseagreen", LIGHTSEAGREEN);
            colors.put("lightskyblue", LIGHTSKYBLUE);
            colors.put("lightslategray", LIGHTSLATEGRAY);
            colors.put("lightslategrey", LIGHTSLATEGREY);
            colors.put("lightsteelblue", LIGHTSTEELBLUE);
            colors.put("lightyellow", LIGHTYELLOW);
            colors.put("lime", LIME);
            colors.put("limegreen", LIMEGREEN);
            colors.put("linen", LINEN);
            colors.put("magenta", MAGENTA);
            colors.put("maroon", MAROON);
            colors.put("mediumaquamarine", MEDIUMAQUAMARINE);
            colors.put("mediumblue", MEDIUMBLUE);
            colors.put("mediumorchid", MEDIUMORCHID);
            colors.put("mediumpurple", MEDIUMPURPLE);
            colors.put("mediumseagreen", MEDIUMSEAGREEN);
            colors.put("mediumslateblue", MEDIUMSLATEBLUE);
            colors.put("mediumspringgreen", MEDIUMSPRINGGREEN);
            colors.put("mediumturquoise", MEDIUMTURQUOISE);
            colors.put("mediumvioletred", MEDIUMVIOLETRED);
            colors.put("midnightblue", MIDNIGHTBLUE);
            colors.put("mintcream", MINTCREAM);
            colors.put("mistyrose", MISTYROSE);
            colors.put("moccasin", MOCCASIN);
            colors.put("navajowhite", NAVAJOWHITE);
            colors.put("navy", NAVY);
            colors.put("oldlace", OLDLACE);
            colors.put("olive", OLIVE);
            colors.put("olivedrab", OLIVEDRAB);
            colors.put("orange", ORANGE);
            colors.put("orangered", ORANGERED);
            colors.put("orchid", ORCHID);
            colors.put("palegoldenrod", PALEGOLDENROD);
            colors.put("palegreen", PALEGREEN);
            colors.put("paleturquoise", PALETURQUOISE);
            colors.put("palevioletred", PALEVIOLETRED);
            colors.put("papayawhip", PAPAYAWHIP);
            colors.put("peachpuff", PEACHPUFF);
            colors.put("peru", PERU);
            colors.put("pink", PINK);
            colors.put("plum", PLUM);
            colors.put("powderblue", POWDERBLUE);
            colors.put("purple", PURPLE);
            colors.put("red", RED);
            colors.put("rosybrown", ROSYBROWN);
            colors.put("royalblue", ROYALBLUE);
            colors.put("saddlebrown", SADDLEBROWN);
            colors.put("salmon", SALMON);
            colors.put("sandybrown", SANDYBROWN);
            colors.put("seagreen", SEAGREEN);
            colors.put("seashell", SEASHELL);
            colors.put("sienna", SIENNA);
            colors.put("silver", SILVER);
            colors.put("skyblue", SKYBLUE);
            colors.put("slateblue", SLATEBLUE);
            colors.put("slategray", SLATEGRAY);
            colors.put("slategrey", SLATEGREY);
            colors.put("snow", SNOW);
            colors.put("springgreen", SPRINGGREEN);
            colors.put("steelblue", STEELBLUE);
            colors.put("tan", TAN);
            colors.put("teal", TEAL);
            colors.put("thistle", THISTLE);
            colors.put("tomato", TOMATO);
            colors.put("transparent", TRANSPARENT);
            colors.put("turquoise", TURQUOISE);
            colors.put("violet", VIOLET);
            colors.put("wheat", WHEAT);
            colors.put("white", WHITE);
            colors.put("whitesmoke", WHITESMOKE);
            colors.put("yellow", YELLOW);
            colors.put("yellowgreen", YELLOWGREEN);
            return colors;
        }

        private static Colors get(String name) {
            return namedColors.get(name);
        }
    }
}

