/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.smartinventory.listener;

import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Page;
import tr.com.infumia.infumialib.platform.paper.smartinventory.SmartInventory;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.IcClickEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.PgBottomClickEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.PgClickEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.PgOutsideClickEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.util.SlotPos;

public final class InventoryClickListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        SmartInventory.getHolder(event.getWhoClicked().getUniqueId()).ifPresent(holder -> {
            int column;
            if (event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
                event.setCancelled(true);
                return;
            }
            Page page = holder.getPage();
            InventoryContents contents = holder.getContents();
            Plugin plugin = holder.getPlugin();
            Inventory clicked = event.getClickedInventory();
            if (clicked == null) {
                page.accept(new PgOutsideClickEvent(contents, event, plugin));
                return;
            }
            HumanEntity player = event.getWhoClicked();
            if (clicked.equals(player.getOpenInventory().getBottomInventory())) {
                page.accept(new PgBottomClickEvent(contents, event, plugin));
                return;
            }
            ItemStack current = event.getCurrentItem();
            if (current == null || current.getType() == Material.AIR) {
                page.accept(new PgClickEvent(contents, event, plugin));
                return;
            }
            int slot = event.getSlot();
            int row = slot / 9;
            if (!page.checkBounds(row, column = slot % 9)) {
                return;
            }
            SlotPos slotPos = SlotPos.of(row, column);
            if (!contents.isEditable(slotPos)) {
                event.setCancelled(true);
            }
            contents.get(slotPos).ifPresent(item -> item.accept(new IcClickEvent(contents, event, (Icon)item, plugin)));
            if (!contents.isEditable(slotPos) && player instanceof Player) {
                ((Player)player).updateInventory();
            }
        });
    }
}

