/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.smartinventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryOpener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryProvider;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Page;
import tr.com.infumia.infumialib.platform.paper.smartinventory.SmartHolder;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.PgTickEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.listener.InventoryClickListener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.listener.InventoryCloseListener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.listener.InventoryDragListener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.listener.InventoryOpenListener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.listener.PlayerQuitListener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.listener.PluginDisableListener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.opener.ChestInventoryOpener;

public interface SmartInventory {
    public static final List<InventoryOpener> DEFAULT_OPENERS = Collections.singletonList(new ChestInventoryOpener());
    public static final List<Listener> LISTENERS = Arrays.asList(new InventoryClickListener(), new InventoryOpenListener(), new InventoryCloseListener(), new PlayerQuitListener(), new PluginDisableListener(), new InventoryDragListener());

    public static void closeAllSmartInventories() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!SmartInventory.getHolder(player).isPresent()) continue;
            player.closeInventory();
        }
    }

    @NotNull
    public static Optional<SmartHolder> getHolder(@NotNull Player player) {
        InventoryHolder holder = player.getOpenInventory().getTopInventory().getHolder();
        if (!(holder instanceof SmartHolder)) {
            return Optional.empty();
        }
        return Optional.of((SmartHolder)holder).filter(SmartHolder::isActive);
    }

    @NotNull
    public static Optional<SmartHolder> getHolder(@NotNull UUID uniqueId) {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)uniqueId)).flatMap(SmartInventory::getHolder);
    }

    @NotNull
    public static List<SmartHolder> getHolders() {
        ArrayList<SmartHolder> list = new ArrayList<SmartHolder>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            SmartInventory.getHolder(player).ifPresent(list::add);
        }
        return list;
    }

    @NotNull
    public static List<Player> getOpenedPlayers(@NotNull Page page) {
        ArrayList<Player> list = new ArrayList<Player>();
        for (SmartHolder holder : SmartInventory.getHolders()) {
            if (!page.id().equals(holder.getPage().id())) continue;
            list.add(holder.getPlayer());
        }
        return list;
    }

    public static void notifyUpdate(@NotNull Player player) {
        SmartInventory.getHolder(player).ifPresent(smartHolder -> smartHolder.getContents().notifyUpdate());
    }

    public static <T extends InventoryProvider> void notifyUpdateForAll(@NotNull Class<T> provider) {
        for (SmartHolder smartHolder : SmartInventory.getHolders()) {
            InventoryContents contents = smartHolder.getContents();
            if (!provider.equals(contents.page().provider().getClass())) continue;
            contents.notifyUpdate();
        }
    }

    public static void notifyUpdateForAllById(@NotNull String id) {
        for (SmartHolder smartHolder : SmartInventory.getHolders()) {
            Page page = smartHolder.getPage();
            if (!page.id().equals(id)) continue;
            page.notifyUpdateForAll();
        }
    }

    @NotNull
    default public Optional<InventoryOpener> findOpener(@NotNull InventoryType type) {
        for (InventoryOpener opener : this.getOpeners()) {
            if (!opener.supports(type)) continue;
            return Optional.of(opener);
        }
        for (InventoryOpener opener : DEFAULT_OPENERS) {
            if (!opener.supports(type)) continue;
            return Optional.of(opener);
        }
        return Optional.empty();
    }

    @NotNull
    public Collection<InventoryOpener> getOpeners();

    @NotNull
    public Plugin getPlugin();

    @NotNull
    default public Optional<BukkitRunnable> getTask(@NotNull UUID uniqueId) {
        return Optional.ofNullable(this.getTasks().get(uniqueId));
    }

    @NotNull
    public Map<UUID, BukkitRunnable> getTasks();

    default public void init() {
        LISTENERS.forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, this.getPlugin()));
    }

    default public void registerOpeners(InventoryOpener ... openers) {
        this.getOpeners().addAll(Arrays.asList(openers));
    }

    default public void removeTask(@NotNull UUID uniqueId) {
        this.getTasks().remove(uniqueId);
    }

    default public void setTask(@NotNull UUID uniqueId, @NotNull BukkitRunnable task) {
        this.getTasks().put(uniqueId, task);
    }

    default public void stopTick(@NotNull UUID uniqueId) {
        this.getTask(uniqueId).ifPresent(runnable -> {
            Bukkit.getScheduler().cancelTask(runnable.getTaskId());
            this.removeTask(uniqueId);
        });
    }

    default public void tick(final @NotNull UUID uniqueId, final @NotNull Page page) {
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                SmartInventory.getHolder(uniqueId).map(SmartHolder::getContents).ifPresent(contents -> {
                    page.accept(new PgTickEvent((InventoryContents)contents));
                    page.provider().tick((InventoryContents)contents);
                });
            }
        };
        this.setTask(uniqueId, task);
        if (page.async()) {
            task.runTaskTimerAsynchronously(this.getPlugin(), page.startDelay(), page.tick());
        } else {
            task.runTaskTimer(this.getPlugin(), page.startDelay(), page.tick());
        }
    }

    default public void unregisterOpeners(InventoryOpener ... openers) {
        this.getOpeners().removeAll(Arrays.asList(openers));
    }
}

