/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.scoreboard;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.scoreboard.Board;
import tr.com.infumia.infumialib.scoreboard.BoardType;
import tr.com.infumia.infumialib.scoreboard.line.Line;

public final class BukkitPlayerScoreboard
implements Closeable {
    @NotNull
    private final Board<Player> board;
    @NotNull
    private final List<Entry> entries = new ArrayList<Entry>();
    @NotNull
    private final List<String> identifiers = new ArrayList<String>();
    @NotNull
    private final List<Line<Player>> lines;
    @NotNull
    private final Plugin plugin;
    private final AtomicBoolean setup = new AtomicBoolean();
    @NotNull
    private final UUID uniqueId;

    static void close(@NotNull Player player) {
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        if (scoreboardManager != null) {
            player.setScoreboard(scoreboardManager.getNewScoreboard());
        }
    }

    @NotNull
    static BukkitPlayerScoreboard create(@NotNull Board<Player> board, @NotNull List<Line<Player>> lines, @NotNull Plugin plugin, @NotNull UUID uniqueId) {
        BukkitPlayerScoreboard scoreboard = new BukkitPlayerScoreboard(board, lines, plugin, uniqueId);
        scoreboard.setup();
        return scoreboard;
    }

    @NotNull
    private static String getRandomChatColor(int position) {
        return ChatColor.values()[position].toString();
    }

    @Override
    public void close() {
        Player player = Bukkit.getPlayer((UUID)this.uniqueId);
        if (player == null) {
            return;
        }
        BukkitPlayerScoreboard.close(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick() {
        AtomicBoolean atomicBoolean = this.setup;
        synchronized (atomicBoolean) {
            Entry entry;
            if (!this.setup.get()) {
                return;
            }
            Player player = Bukkit.getPlayer((UUID)this.uniqueId);
            if (player == null) {
                return;
            }
            Optional<Scoreboard> optionalScoreboard = this.getScoreboard();
            if (optionalScoreboard.isEmpty()) {
                return;
            }
            Optional<Objective> optionalObjective = this.getObjective();
            if (optionalObjective.isEmpty()) {
                return;
            }
            Objective objective = optionalObjective.get();
            String title = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)this.board.getTitleLine().apply((Object)player)));
            Scoreboard scoreboard = optionalScoreboard.get();
            if (!objective.getDisplayName().equals(title)) {
                objective.setDisplayName(title);
            }
            if (this.lines.isEmpty()) {
                this.entries.forEach(Entry::remove);
                this.entries.clear();
                if (player.getScoreboard() != scoreboard) {
                    player.setScoreboard(scoreboard);
                }
                return;
            }
            List<Line<Player>> newLines = this.lines.size() > 15 ? this.lines.subList(0, 15) : new ArrayList<Line<Player>>(this.lines);
            BoardType boardType = this.board.getType();
            if (!boardType.isDescending()) {
                Collections.reverse(newLines);
            }
            if (this.entries.size() > newLines.size()) {
                int bound = this.entries.size();
                for (int i = newLines.size(); i < bound; ++i) {
                    entry = this.getEntry(i);
                    if (entry == null) continue;
                    entry.remove();
                }
            }
            int cache = boardType.getStartNumber();
            for (int index = 0; index < newLines.size(); ++index) {
                entry = this.getEntry(index);
                String line = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)newLines.get(index).apply((Object)player)));
                if (entry == null) {
                    entry = new Entry(this.generateIdentifier(index), this, line);
                } else {
                    entry.setLine(line);
                }
                entry.setup();
                entry.send(boardType.isDescending() ? cache-- : cache++);
            }
            if (player.getScoreboard() != scoreboard) {
                player.setScoreboard(scoreboard);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(@NotNull List<Line<Player>> lines) {
        List<Line<Player>> list = this.lines;
        synchronized (list) {
            int bound = lines.size();
            for (int index = 0; index < bound; ++index) {
                Line<Player> line = lines.get(index);
                if (!line.isUpdate()) continue;
                this.lines.set(index, line);
            }
        }
    }

    @NotNull
    private String generateIdentifier(int position) {
        String identifier = BukkitPlayerScoreboard.getRandomChatColor(position) + ChatColor.WHITE;
        while (this.identifiers.contains(identifier)) {
            identifier = identifier + BukkitPlayerScoreboard.getRandomChatColor(position) + ChatColor.WHITE;
        }
        if (identifier.length() > 64) {
            return this.generateIdentifier(position);
        }
        this.identifiers.add(identifier);
        return identifier;
    }

    @Nullable
    private Entry getEntry(int position) {
        return position >= this.entries.size() ? null : this.entries.get(position);
    }

    @NotNull
    private Optional<Objective> getObjective() {
        Player player = Bukkit.getPlayer((UUID)this.uniqueId);
        if (player == null) {
            return Optional.empty();
        }
        Optional<Scoreboard> optionalScoreboard = this.getScoreboard();
        if (optionalScoreboard.isEmpty()) {
            return Optional.empty();
        }
        Scoreboard scoreboard = optionalScoreboard.get();
        if (scoreboard.getObjective("SBoard") == null) {
            Objective objective = scoreboard.registerNewObjective("SBoard", "dummy", (String)this.board.getTitleLine().apply((Object)player));
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
            return Optional.of(objective);
        }
        return Optional.ofNullable(scoreboard.getObjective("SBoard"));
    }

    @NotNull
    private Optional<Scoreboard> getScoreboard() {
        Player player = Bukkit.getPlayer((UUID)this.uniqueId);
        if (player == null) {
            return Optional.empty();
        }
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        if (scoreboardManager == null) {
            return Optional.empty();
        }
        if (player.getScoreboard() != scoreboardManager.getMainScoreboard()) {
            return Optional.of(player.getScoreboard());
        }
        return Optional.of(scoreboardManager.getNewScoreboard());
    }

    private void setup() {
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Player player = Bukkit.getPlayer((UUID)this.uniqueId);
            if (player != null) {
                this.getScoreboard().ifPresent(arg_0 -> ((Player)player).setScoreboard(arg_0));
                this.getObjective();
            }
            this.setup.set(true);
        });
    }

    private BukkitPlayerScoreboard(@NotNull Board<Player> board, @NotNull List<Line<Player>> lines, @NotNull Plugin plugin, @NotNull UUID uniqueId) {
        if (board == null) {
            throw new NullPointerException("board is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        this.board = board;
        this.lines = lines;
        this.plugin = plugin;
        this.uniqueId = uniqueId;
    }

    @NotNull
    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    private static final class Entry {
        @NotNull
        private final String identifier;
        @NotNull
        private final BukkitPlayerScoreboard scoreboard;
        @NotNull
        private String line;
        @Nullable
        private Team team;

        private void remove() {
            this.scoreboard.getIdentifiers().remove(this.identifier);
            this.scoreboard.getScoreboard().ifPresent(score -> score.resetScores(this.identifier));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(int position) {
            Team team = this.team;
            synchronized (team) {
                if (this.team == null) {
                    return;
                }
                if (this.line.length() > 64) {
                    Object suffix;
                    String prefix = this.line.substring(0, 63);
                    if (prefix.charAt(62) == '\u00a7') {
                        prefix = prefix.substring(0, 61);
                        suffix = this.line.substring(61);
                    } else if (prefix.charAt(61) == '\u00a7') {
                        prefix = prefix.substring(0, 61);
                        suffix = this.line.substring(61);
                    } else {
                        suffix = ChatColor.getLastColors((String)prefix).equalsIgnoreCase(ChatColor.getLastColors((String)this.identifier)) ? this.line.substring(63) : ChatColor.getLastColors((String)prefix) + this.line.substring(63);
                    }
                    if (((String)suffix).length() > 62) {
                        suffix = ((String)suffix).substring(0, 63);
                    }
                    this.team.setPrefix(prefix);
                    this.team.setSuffix((String)suffix);
                } else {
                    this.team.setPrefix(this.line);
                    this.team.setSuffix("");
                }
                this.scoreboard.getObjective().map(objective -> objective.getScore(this.identifier)).ifPresent(score -> score.setScore(position));
            }
        }

        private void setup() {
            this.scoreboard.getScoreboard().ifPresent(score -> {
                String teamName = this.identifier.length() > 64 ? this.identifier.substring(0, 63) : this.identifier;
                Team team = score.getTeam(teamName);
                if (team == null) {
                    team = score.registerNewTeam(teamName);
                }
                if (team.getEntries().isEmpty() || !team.getEntries().contains(this.identifier)) {
                    team.addEntry(this.identifier);
                }
                if (!this.scoreboard.entries.contains(this)) {
                    this.scoreboard.entries.add(this);
                }
                this.team = team;
            });
        }

        public Entry(@NotNull String identifier, @NotNull BukkitPlayerScoreboard scoreboard, @NotNull String line) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            if (scoreboard == null) {
                throw new NullPointerException("scoreboard is marked non-null but is null");
            }
            if (line == null) {
                throw new NullPointerException("line is marked non-null but is null");
            }
            this.identifier = identifier;
            this.scoreboard = scoreboard;
            this.line = line;
        }

        public void setLine(@NotNull String line) {
            if (line == null) {
                throw new NullPointerException("line is marked non-null but is null");
            }
            this.line = line;
        }
    }
}

