/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import com.cryptomorin.xseries.ReflectionUtils;
import com.cryptomorin.xseries.SkullUtils;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.bukkitversion.BukkitVersion;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;
import tr.com.infumia.reflection.RefConstructed;
import tr.com.infumia.reflection.cls.ClassOf;

public final class SkullItemBuilder
extends ItemStackBuilder<SkullMeta, SkullItemBuilder> {
    private SkullItemBuilder(@NotNull SkullMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static SkullItemBuilder from(@NotNull SkullMeta itemMeta, @NotNull ItemStack itemStack) {
        return new SkullItemBuilder(itemMeta, itemStack);
    }

    @Override
    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.deserialize(node);
        Optional.ofNullable(node.node(new Object[]{"skull"}).getString()).ifPresent(this::owner);
    }

    @Override
    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.serialize(node);
        node.node(new Object[]{"skull"}).set((Object)SkullUtils.getSkinValue(this.itemMeta()));
    }

    @NotNull
    public SkullItemBuilder owner(@NotNull String texture) {
        SkullUtils.applySkin(this.itemMeta(), (String)texture);
        ClassOf cls = new ClassOf((Object)((SkullMeta)this.itemMeta()));
        Object profile = cls.getField("profile").flatMap(refField -> refField.of(this.itemMeta()).getValue()).orElseThrow();
        Object nbt = new ClassOf(Objects.requireNonNull(ReflectionUtils.getNMSClass((String)"NBTTagCompound"))).getConstructor(new Object[0]).flatMap(rec$ -> ((RefConstructed)rec$).create(new Object[0])).orElseThrow();
        Object serialized = new ClassOf(Objects.requireNonNull(ReflectionUtils.getNMSClass((String)"GameProfileSerializer"))).getMethodByName(new String[]{"serialize"}).flatMap(refMethod -> refMethod.call(new Object[]{nbt, profile})).orElseThrow();
        cls.getField("serializedProfile").map(refField -> refField.of(this.itemMeta())).ifPresent(refFieldExecuted -> refFieldExecuted.setValue(serialized));
        return this.self();
    }

    @NotNull
    public SkullItemBuilder removeOwner() {
        if (BukkitVersion.MAJOR < 13) {
            ((SkullMeta)this.itemMeta()).setOwner(null);
        } else {
            ((SkullMeta)this.itemMeta()).setOwningPlayer(null);
        }
        return this.self();
    }

    @NotNull
    public SkullItemBuilder self() {
        return this;
    }
}

