/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.infumialib.platform.paper.configurate.ItemStackSerializer;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;

public final class CrossbowItemBuilder
extends ItemStackBuilder<CrossbowMeta, CrossbowItemBuilder> {
    private CrossbowItemBuilder(@NotNull CrossbowMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static CrossbowItemBuilder from(@NotNull CrossbowMeta itemMeta, @NotNull ItemStack itemStack) {
        return new CrossbowItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public CrossbowItemBuilder addChargedProjectile(ItemStack ... projectiles) {
        CrossbowMeta itemMeta = (CrossbowMeta)this.itemMeta();
        Arrays.stream(projectiles).forEach(arg_0 -> ((CrossbowMeta)itemMeta).addChargedProjectile(arg_0));
        return this.self();
    }

    @NotNull
    public CrossbowItemBuilder chargedProjectiles(ItemStack ... projectiles) {
        return this.chargedProjectiles(List.of(projectiles));
    }

    @NotNull
    public CrossbowItemBuilder chargedProjectiles(@Nullable List<ItemStack> projectiles) {
        ((CrossbowMeta)this.itemMeta()).setChargedProjectiles(projectiles);
        return this.self();
    }

    @Override
    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.deserialize(node);
        ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
        ConfigurationNode projectilesNode = node.node(new Object[]{"projectiles"});
        for (Map.Entry entry : projectilesNode.childrenMap().entrySet()) {
            projectiles.add(ItemStackSerializer.INSTANCE.deserialize(null, (ConfigurationNode)entry.getValue()));
        }
        this.chargedProjectiles(projectiles);
    }

    @Override
    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.serialize(node);
        List chargedProjectiles = ((CrossbowMeta)this.itemMeta()).getChargedProjectiles();
        int bound = chargedProjectiles.size();
        ConfigurationNode projectilesNode = node.node(new Object[]{"projectiles"});
        for (int index = 0; index < bound; ++index) {
            ItemStackSerializer.INSTANCE.serialize((Type)null, (ItemStack)chargedProjectiles.get(index), projectilesNode.node(new Object[]{String.valueOf(index)}));
        }
    }

    @NotNull
    public CrossbowItemBuilder self() {
        return this;
    }
}

