/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.smartinventory.event;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.SmartInventory;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.abs.DragEvent;

public final class IcDragEvent
implements DragEvent {
    @NotNull
    private final InventoryContents contents;
    @NotNull
    private final InventoryDragEvent event;
    @NotNull
    private final Icon icon;
    @NotNull
    private final Plugin plugin;

    @Override
    @NotNull
    public Map<Integer, ItemStack> added() {
        return this.event.getNewItems();
    }

    @Override
    @NotNull
    public DragType drag() {
        return this.event.getType();
    }

    @Override
    @NotNull
    public InventoryDragEvent getEvent() {
        return this.event;
    }

    @Override
    @NotNull
    public Optional<ItemStack> newCursor() {
        return Optional.ofNullable(this.event.getCursor());
    }

    @Override
    @NotNull
    public Set<Integer> slots() {
        return this.event.getInventorySlots();
    }

    @Override
    public void cancel() {
        this.event.setCancelled(true);
    }

    @Override
    public void close() {
        Bukkit.getScheduler().runTask(this.plugin, () -> SmartInventory.getHolder(this.contents.player()).ifPresent(holder -> holder.getPlayer().closeInventory()));
    }

    @Override
    @NotNull
    public InventoryContents contents() {
        return this.contents;
    }

    @Override
    @NotNull
    public Icon icon() {
        return this.icon;
    }

    public IcDragEvent(@NotNull InventoryContents contents, @NotNull InventoryDragEvent event, @NotNull Icon icon, @NotNull Plugin plugin) {
        if (contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (icon == null) {
            throw new NullPointerException("icon is marked non-null but is null");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.contents = contents;
        this.event = event;
        this.icon = icon;
        this.plugin = plugin;
    }
}

