/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.misc;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class Position {
    @Setting
    private float pitch;
    @Setting
    @NotNull
    private String worldName;
    @Setting
    private double x;
    @Setting
    private double y;
    @Setting
    private float yaw;
    @Setting
    private double z;

    public Position(@NotNull String worldName, double x, double y, double z, float yaw, float pitch) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Position(@NotNull String worldName, double x, double y, double z) {
        this(worldName, x, y, z, 0.0f, 0.0f);
    }

    public Position(@NotNull String worldName, int x, int y, int z, float yaw, float pitch) {
        this(worldName, (double)x, (double)y, (double)z, yaw, pitch);
    }

    public Position(@NotNull String worldName, int x, int y, int z) {
        this(worldName, (double)x, (double)y, (double)z);
    }

    @NotNull
    public Optional<Location> location() {
        return Optional.ofNullable(Bukkit.getWorld((String)this.worldName)).map(world -> new Location(world, this.x, this.y, this.z, this.yaw, this.pitch));
    }

    @NotNull
    public Location locationThrown() {
        return this.location().orElseThrow(() -> new IllegalStateException("World %s not found!".formatted(this.worldName)));
    }

    public float pitch() {
        return this.pitch;
    }

    @NotNull
    public String worldName() {
        return this.worldName;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public float yaw() {
        return this.yaw;
    }

    public double z() {
        return this.z;
    }

    public Position pitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public Position worldName(@NotNull String worldName) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.worldName = worldName;
        return this;
    }

    public Position x(double x) {
        this.x = x;
        return this;
    }

    public Position y(double y) {
        this.y = y;
        return this;
    }

    public Position yaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    public Position z(double z) {
        this.z = z;
        return this;
    }
}

