/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.files;

import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import tr.com.infumia.infumialib.configurate.InfumiaCollection;
import tr.com.infumia.infumialib.platform.paper.configurate.PaperCollection;

@ConfigSerializable
public final class PaperConfig {
    @NotNull
    private static PaperConfig INSTANCE = new PaperConfig();
    @Setting
    @Comment(value="Hooking message for each plugin/library.")
    private String hookMessage = "{#F0E68C}%hook% {#AFEEEE}is hooking.";

    public static void init(@NotNull Path directory) throws ConfigurateException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(directory.resolve("paper.conf"))).defaultOptions(options -> options.implicitInitialization(false).serializers(builder -> builder.registerAll(InfumiaCollection.COLLECTION).registerAll(PaperCollection.COLLECTION)))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        PaperConfig config = (PaperConfig)node.get(PaperConfig.class, (Object)new PaperConfig());
        node.set(PaperConfig.class, (Object)config);
        loader.save((ConfigurationNode)node);
        INSTANCE = config;
    }

    @NotNull
    public static PaperConfig instance() {
        return INSTANCE;
    }

    public String hookMessage() {
        return this.hookMessage;
    }

    public PaperConfig hookMessage(String hookMessage) {
        this.hookMessage = hookMessage;
        return this;
    }
}

