/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.kubernetes;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.kubernetes.DiscoveredService;
import tr.com.infumia.infumialib.kubernetes.DiscoveryService;
import tr.com.infumia.infumialib.kubernetes.DiscoveryWatcher;
import tr.com.infumia.infumialib.kubernetes.ServerRegistry;

public final class DiscoveryScanner {
    private static final Logger log = LogManager.getLogger(DiscoveryScanner.class);
    private final Set<DiscoveredService> currentServices = new HashSet<DiscoveredService>();
    @NotNull
    private final DiscoveryService discovery;
    @NotNull
    private final DiscoveryWatcher watcher;

    @NotNull
    public static DiscoveryScanner init(@NotNull DiscoveryService service, @NotNull DiscoveryWatcher watcher) {
        return new DiscoveryScanner(service, watcher);
    }

    public void scan() {
        long start = System.currentTimeMillis();
        log.debug("Performing discovery...");
        Map services = (Map)this.discovery.get();
        this.currentServices.removeIf(service -> {
            DiscoveredService found = (DiscoveredService)services.get(service.name());
            if (found == null) {
                this.handleDeletedService((DiscoveredService)service);
                return true;
            }
            if (!found.isActive()) {
                this.handleDeletedService((DiscoveredService)service);
                return true;
            }
            return false;
        });
        for (DiscoveredService service2 : services.values()) {
            if (this.currentServices.contains(service2)) continue;
            this.currentServices.add(service2);
            this.handleCreatedService(service2);
        }
        log.debug("Finished discovering, took {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private void handleCreatedService(@NotNull DiscoveredService service) {
        log.info("Pod {} was created, adding...", (Object)service);
        ServerRegistry.register(service);
        this.watcher.onCreate(service);
    }

    private void handleDeletedService(@NotNull DiscoveredService service) {
        log.info("Pod {} was deleted, removing...", (Object)service);
        ServerRegistry.unregister(service);
        this.watcher.onDelete(service);
    }

    public DiscoveryScanner(@NotNull DiscoveryService discovery, @NotNull DiscoveryWatcher watcher) {
        if (discovery == null) {
            throw new NullPointerException("discovery is marked non-null but is null");
        }
        if (watcher == null) {
            throw new NullPointerException("watcher is marked non-null but is null");
        }
        this.discovery = discovery;
        this.watcher = watcher;
    }
}

