/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.kubernetes;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.kubernetes.DiscoveredService;

public interface ServerRegistry {
    public static final Set<DiscoveredService> GAMEPLAY_SERVICES = new HashSet<DiscoveredService>();
    public static final Set<DiscoveredService> LOBBY_SERVICES = new HashSet<DiscoveredService>();
    public static final Set<DiscoveredService> PROXY_SERVICES = new HashSet<DiscoveredService>();

    public static void register(@NotNull DiscoveredService service) {
        if (service.isGameplay()) {
            GAMEPLAY_SERVICES.add(service);
        }
        if (service.isProxy()) {
            PROXY_SERVICES.add(service);
        }
        if (service.isLobby()) {
            LOBBY_SERVICES.add(service);
        }
    }

    public static void unregister(@NotNull DiscoveredService service) {
        GAMEPLAY_SERVICES.remove(service);
        LOBBY_SERVICES.remove(service);
        PROXY_SERVICES.remove(service);
    }
}

