/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.common.registries;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.api.definitions.Definition;

public final class Registry<K, V extends Definition.Key<K>> {
    private final Object2ObjectMap<K, V> values = new Object2ObjectOpenHashMap();

    @NotNull
    public Optional<V> get(@NotNull K key) {
        return Optional.ofNullable((Definition.Key)this.values.get(key));
    }

    @NotNull
    public Map<K, V> getValues() {
        return Object2ObjectMaps.unmodifiable(this.values);
    }

    public void register(@NotNull V value) {
        this.values.put(value.key(), value);
    }

    public void unregister(@NotNull V value) {
        this.unregister((K)value.key());
    }

    public void unregister(@NotNull K key) {
        this.values.remove(key);
    }
}

