/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.api.reflection.clazz;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.api.reflection.RefClass;
import tr.com.infumia.infumialib.api.reflection.RefConstructed;
import tr.com.infumia.infumialib.api.reflection.RefField;
import tr.com.infumia.infumialib.api.reflection.RefMethod;
import tr.com.infumia.infumialib.api.reflection.constructor.ConstructorOf;
import tr.com.infumia.infumialib.api.reflection.field.FieldOf;
import tr.com.infumia.infumialib.api.reflection.method.MethodOf;
import tr.com.infumia.infumialib.api.reflection.parameterized.ParameterizedOf;

public final class ClassOf<T>
implements RefClass<T> {
    private static final Logger log = Logger.getLogger(ClassOf.class.getName());
    @NotNull
    private final Class<T> clazz;

    public ClassOf(@NotNull T object) {
        this(object.getClass());
    }

    public ClassOf(@NotNull String className) throws ClassNotFoundException {
        this(Class.forName(className));
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.clazz.getDeclaredAnnotation(annotationClass));
    }

    @Override
    @NotNull
    public Optional<RefConstructed<T>> getConstructor(Object ... types) {
        return this.getConstructor0(false, types);
    }

    @Override
    @NotNull
    public Optional<RefConstructed<T>> getConstructor(int number) {
        ArrayList constructors = new ArrayList(Arrays.asList(this.clazz.getConstructors()));
        constructors.addAll(Arrays.asList(this.clazz.getDeclaredConstructors()));
        for (Constructor<?> constructor : constructors) {
            if (constructor == null || constructor.getParameterTypes().length != number) continue;
            return Optional.of(new ConstructorOf(constructor));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public List<RefField> getDeclaredFields() {
        ArrayList<RefField> list = new ArrayList<RefField>();
        for (Field field : this.clazz.getDeclaredFields()) {
            list.add(new FieldOf(field));
        }
        return list;
    }

    @Override
    @NotNull
    public List<RefMethod> getDeclaredMethods() {
        ArrayList<RefMethod> list = new ArrayList<RefMethod>();
        for (Method method : this.clazz.getDeclaredMethods()) {
            list.add(new MethodOf(method));
        }
        return list;
    }

    @Override
    @NotNull
    public Optional<RefField> getField(@NotNull String name) {
        try {
            return Optional.of(new FieldOf(this.clazz.getField(name)));
        }
        catch (NoSuchFieldException ignored) {
            try {
                return Optional.of(new FieldOf(this.clazz.getDeclaredField(name)));
            }
            catch (NoSuchFieldException exception) {
                log.log(Level.SEVERE, "ClassOf#getField(String)", exception);
                return Optional.empty();
            }
        }
    }

    @Override
    @NotNull
    public <X> Optional<RefField> getField(@NotNull RefClass<X> type) {
        return this.getField(type.getRealClass());
    }

    @Override
    @NotNull
    public Optional<RefField> getField(@NotNull Class<?> type) {
        List<RefField> fields = this.getFields();
        fields.addAll(this.getDeclaredFields());
        for (RefField field : fields) {
            if (field == null || !type.equals(field.getType())) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public List<RefField> getFields() {
        ArrayList<RefField> list = new ArrayList<RefField>();
        for (Field field : this.clazz.getFields()) {
            list.add(new FieldOf(field));
        }
        return list;
    }

    @Override
    @NotNull
    public Optional<RefMethod> getMethod(@NotNull String name, Object ... types) {
        return this.getMethod0(name, false, types);
    }

    @Override
    @NotNull
    public Optional<RefMethod> getMethodByName(String ... names) {
        List<RefMethod> methods = this.getMethods();
        methods.addAll(this.getDeclaredMethods());
        for (RefMethod method : methods) {
            if (method == null) continue;
            String found = null;
            int n = 0;
            String[] stringArray = names;
            int n2 = stringArray.length;
            if (n < n2) {
                String s;
                found = s = stringArray[n];
            }
            if (found == null || !method.getName().equals(found)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Optional<RefMethod> getMethodByParameter(Object ... types) {
        return this.findMethod0(false, types);
    }

    @Override
    @NotNull
    public <X> Optional<RefMethod> getMethodByReturnType(@NotNull RefClass<X> type) {
        return this.getMethodByReturnType(type.getRealClass());
    }

    @Override
    @NotNull
    public Optional<RefMethod> getMethodByReturnType(@NotNull Class<?> type) {
        List<RefMethod> methods = this.getMethods();
        methods.addAll(this.getDeclaredMethods());
        for (RefMethod method : methods) {
            if (method == null || !type.equals(method.getReturnType())) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public List<RefMethod> getMethods() {
        ArrayList<RefMethod> list = new ArrayList<RefMethod>();
        for (Method method : this.clazz.getMethods()) {
            list.add(new MethodOf(method));
        }
        return list;
    }

    @Override
    @NotNull
    public Optional<RefConstructed<T>> getPrimitiveConstructor(Object ... types) {
        return this.getConstructor0(true, types);
    }

    @Override
    @NotNull
    public Optional<RefMethod> getPrimitiveMethod(@NotNull String name, Object ... types) {
        return this.getMethod0(name, true, types);
    }

    @Override
    @NotNull
    public Optional<RefMethod> getPrimitiveMethodByParameter(Object ... types) {
        return this.findMethod0(true, types);
    }

    @Override
    @NotNull
    public Class<T> getRealClass() {
        return this.clazz;
    }

    @Override
    public boolean isInstance(@NotNull Object object) {
        return this.clazz.isInstance(object);
    }

    @Override
    public boolean hasFinal() {
        return Modifier.isFinal(this.clazz.getModifiers());
    }

    @Override
    public boolean hasPrivate() {
        return Modifier.isPrivate(this.clazz.getModifiers());
    }

    @Override
    public boolean hasPublic() {
        return Modifier.isPublic(this.clazz.getModifiers());
    }

    @Override
    public boolean hasStatic() {
        return Modifier.isStatic(this.clazz.getModifiers());
    }

    @NotNull
    private Optional<RefMethod> findMethod0(boolean primitive, Object ... types) {
        ParameterizedOf parameter = new ParameterizedOf(primitive, types);
        List<RefMethod> methods = this.getMethods();
        methods.addAll(this.getDeclaredMethods());
        ArrayList classList = new ArrayList();
        parameter.apply(classes -> {
            classList.addAll(Arrays.asList(classes));
            return Optional.empty();
        });
        block0: for (RefMethod method : methods) {
            Object[] methodTypes = method.getParameterTypes();
            if (methodTypes.length != classList.size()) continue;
            for (int index = 0; index < classList.size(); ++index) {
                if (!Arrays.equals(classList.toArray(new Class[0]), methodTypes)) continue block0;
            }
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<RefConstructed<T>> getConstructor0(boolean primitive, Object ... types) {
        ParameterizedOf parameter = new ParameterizedOf(primitive, types);
        return parameter.apply(classes -> {
            try {
                return Optional.of(new ConstructorOf<T>(this.clazz.getConstructor((Class<?>)classes)));
            }
            catch (NoSuchMethodException exception) {
                return parameter.apply(declaredClasses -> {
                    try {
                        return Optional.of(new ConstructorOf<T>(this.clazz.getDeclaredConstructor((Class<?>)declaredClasses)));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        log.log(Level.SEVERE, "ClassOf#getConstructor0(boolean, Object[])", exception);
                        return Optional.empty();
                    }
                });
            }
        });
    }

    @NotNull
    private Optional<RefMethod> getMethod0(@NotNull String name, boolean primitive, Object ... types) {
        ParameterizedOf parameter = new ParameterizedOf(primitive, types);
        return parameter.apply(classes -> {
            try {
                return Optional.of(new MethodOf(this.clazz.getMethod(name, (Class<?>)classes)));
            }
            catch (NoSuchMethodException exception) {
                return parameter.apply(declaredClasses -> {
                    try {
                        return Optional.of(new MethodOf(this.clazz.getDeclaredMethod(name, (Class<?>)declaredClasses)));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        log.log(Level.SEVERE, "ClassOf#getMethod0(String, boolean, Object[])", exception);
                        return Optional.empty();
                    }
                });
            }
        });
    }

    public ClassOf(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.clazz = clazz;
    }
}

