/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.dependency;

import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.DependencyReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public final class URLDependencyDataProvider
implements DependencyDataProvider {
    private final DependencyReader dependencyReader;
    private final URL depFileURL;
    private DependencyData cachedData = null;

    public URLDependencyDataProvider(DependencyReader dependencyReader, URL depFileURL) {
        this.dependencyReader = dependencyReader;
        this.depFileURL = depFileURL;
    }

    public DependencyReader getDependencyReader() {
        return this.dependencyReader;
    }

    @Override
    public DependencyData get() throws IOException, ReflectiveOperationException {
        if (this.cachedData != null) {
            return this.cachedData;
        }
        URLConnection connection = this.depFileURL.openConnection();
        connection.setUseCaches(false);
        try (InputStream is = connection.getInputStream();){
            DependencyData dependencyData = this.cachedData = this.dependencyReader.read(is);
            return dependencyData;
        }
    }
}

