/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.common.http;

import com.google.protobuf.GeneratedMessageV3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.common.http.ProtobufHttp;

public abstract class HttpApi {
    @NotNull
    private final String address;
    @NotNull
    private final String path;

    protected final boolean delete(@NotNull String path) {
        return ProtobufHttp.create().delete(this.path(path));
    }

    @Nullable
    protected final <T extends GeneratedMessageV3> T get(@NotNull String path, @NotNull T defaultInstance) {
        return ProtobufHttp.create().get(this.path(path), defaultInstance);
    }

    protected final <T extends GeneratedMessageV3> boolean post(@NotNull String path, @NotNull T defaultInstance) {
        return ProtobufHttp.create().post(this.path(path), defaultInstance);
    }

    @Nullable
    protected final <T extends GeneratedMessageV3, B extends GeneratedMessageV3> T post(@NotNull String path, @NotNull T defaultInstance, @NotNull B body) {
        return ProtobufHttp.create().post(this.path(path), defaultInstance, body);
    }

    @NotNull
    private String path(@NotNull String path) {
        return String.format("%s/%s/%s", this.address, this.path, path);
    }

    protected HttpApi(@NotNull String address, @NotNull String path) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.address = address;
        this.path = path;
    }
}

