/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation.meta;

import io.github.slimjar.relocation.meta.MetaMediator;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserDefinedFileAttributeView;

public final class AttributeMetaMediator
implements MetaMediator {
    private final UserDefinedFileAttributeView view;

    public AttributeMetaMediator(Path path) {
        this.view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
    }

    @Override
    public String readAttribute(String name) {
        try {
            ByteBuffer buf = ByteBuffer.allocate(this.view.size(name));
            this.view.read(name, buf);
            buf.flip();
            return Charset.defaultCharset().decode(buf).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void writeAttribute(String name, String value) {
        try {
            this.view.write(name, Charset.defaultCharset().encode(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

