/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.strategy;

import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.downloader.strategy.FolderedFilePathStrategy;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ChecksumFilePathStrategy
implements FilePathStrategy {
    private static final Logger LOGGER = Logger.getLogger(FolderedFilePathStrategy.class.getName());
    private static final String DEPENDENCY_FILE_FORMAT = "%s/%s/%s/%s/%3$s-%4$s.jar.%5$s";
    private final File rootDirectory;
    private final String algorithm;

    private ChecksumFilePathStrategy(File rootDirectory, String algorithm) {
        this.rootDirectory = rootDirectory;
        this.algorithm = algorithm.replaceAll("[ -]", "").toLowerCase(Locale.ENGLISH);
    }

    @Override
    public File selectFileFor(Dependency dependency) {
        String extendedVersion = Optional.ofNullable(dependency.getSnapshotId()).map(s -> "-" + s).orElse("");
        String path = String.format(DEPENDENCY_FILE_FORMAT, this.rootDirectory.getPath(), dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), dependency.getVersion() + extendedVersion, this.algorithm);
        LOGGER.log(Level.FINEST, "Selected checksum file for " + dependency.getArtifactId() + " at " + path);
        return new File(path);
    }

    public static FilePathStrategy createStrategy(File rootDirectory, String algorithm) throws IllegalArgumentException {
        boolean created;
        if (!rootDirectory.exists() && !(created = rootDirectory.mkdirs())) {
            throw new IllegalArgumentException("Could not create specified directory: " + rootDirectory);
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Expecting a directory for download root! " + rootDirectory);
        }
        return new ChecksumFilePathStrategy(rootDirectory, algorithm);
    }
}

