/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.app.builder;

import io.github.slimjar.app.Application;
import io.github.slimjar.app.builder.ApplicationBuilder;
import io.github.slimjar.app.builder.IsolationConfiguration;
import io.github.slimjar.injector.DependencyInjector;
import io.github.slimjar.injector.loader.IsolatedInjectableClassLoader;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.resolution.PreResolutionDataProvider;
import io.github.slimjar.util.Modules;
import io.github.slimjar.util.Parameters;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;

public final class IsolatedApplicationBuilder
extends ApplicationBuilder {
    private final IsolationConfiguration isolationConfiguration;
    private final Object[] arguments;

    public IsolatedApplicationBuilder(String applicationName, IsolationConfiguration isolationConfiguration, Object[] arguments) {
        super(applicationName);
        this.isolationConfiguration = isolationConfiguration;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    public Application buildApplication() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException {
        DependencyInjector injector = this.createInjector();
        URL[] moduleUrls = Modules.extract(this.isolationConfiguration.getModuleExtractor(), this.isolationConfiguration.getModules());
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader(moduleUrls, this.isolationConfiguration.getParentClassloader(), Collections.singleton(Application.class));
        DependencyDataProvider dataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData selfDependencyData = dataProvider.get();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> preResolutionResultMap = preResolutionDataProvider.get();
        injector.inject(classLoader, selfDependencyData, preResolutionResultMap);
        for (URL module : moduleUrls) {
            DependencyDataProvider moduleDataProvider = this.getModuleDataProviderFactory().create(module);
            DependencyData dependencyData = moduleDataProvider.get();
            injector.inject(classLoader, dependencyData, preResolutionResultMap);
        }
        Class<?> applicationClass = Class.forName(this.isolationConfiguration.getApplicationClass(), true, classLoader);
        return (Application)applicationClass.getConstructor(Parameters.typesFrom(this.arguments)).newInstance(this.arguments);
    }
}

