/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.resolvers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.transformer.TransformResolver;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.postprocessor.PostProcessor;

public class JacksonYaml
extends TransformResolver {
    private static final ObjectMapper MAPPER = new YAMLMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final MapType MAP_TYPE = MAPPER.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
    private Map<String, Object> map = new HashMap<String, Object>();

    @Override
    @NotNull
    public List<String> allKeys() {
        return List.copyOf(this.map.keySet());
    }

    @Override
    @NotNull
    public Optional<Object> getValue(@NotNull String path) {
        return Optional.ofNullable(this.map.get(path));
    }

    @Override
    public void load(@NotNull InputStream inputStream, @NotNull TransformedObjectDeclaration declaration) throws Exception {
        String context = PostProcessor.of(inputStream).getContext();
        this.map = (Map)MAPPER.readValue(context.isEmpty() ? "{}" : context, (JavaType)MAP_TYPE);
        if (this.map == null) {
            this.map = new LinkedHashMap<String, Object>();
        }
    }

    @Override
    public boolean pathExists(@NotNull String path) {
        return this.map.containsKey(path);
    }

    @Override
    public void removeValue(@NotNull String path, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.remove(path);
    }

    @Override
    public void setValue(@NotNull String path, @Nullable Object value, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.put(path, this.serialize(value, genericType, true));
    }

    @Override
    public void write(@NotNull OutputStream outputStream, @NotNull TransformedObjectDeclaration declaration) throws Exception {
        MAPPER.writeValue(outputStream, this.map);
    }
}

