/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.kubernetes;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.kubernetes.DiscoveredService;
import tr.com.infumia.infumialib.kubernetes.DiscoveryService;
import tr.com.infumia.infumialib.kubernetes.DiscoveryWatcher;

public final class DiscoveryScanner {
    private static final Logger log = LogManager.getLogger(DiscoveryScanner.class);
    private final Set<DiscoveredService> currentServices = new HashSet<DiscoveredService>();
    @NotNull
    private final DiscoveryService discovery;
    @NotNull
    private final DiscoveryWatcher watcher;

    public void scan() {
        long start = System.currentTimeMillis();
        log.info("Performing discovery...");
        Set foundServices = (Set)this.discovery.get();
        Iterator<DiscoveredService> iterator = this.currentServices.iterator();
        while (iterator.hasNext()) {
            DiscoveredService currentService = iterator.next();
            if (foundServices.contains(currentService)) continue;
            iterator.remove();
            this.handleDeletedService(currentService);
        }
        List addedServices = foundServices.stream().filter(discoveredService -> !this.currentServices.contains(discoveredService)).peek(this::handleCreatedService).collect(Collectors.toList());
        this.currentServices.addAll(addedServices);
        log.info("Finished discovering, took {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private void handleCreatedService(@NotNull DiscoveredService service) {
        log.info("Pod {} was created, adding...", (Object)service);
        this.watcher.onCreate(service);
    }

    private void handleDeletedService(@NotNull DiscoveredService service) {
        log.info("Pod {} was deleted, removing...", (Object)service);
        this.watcher.onDelete(service);
    }

    public DiscoveryScanner(@NotNull DiscoveryService discovery, @NotNull DiscoveryWatcher watcher) {
        if (discovery == null) {
            throw new NullPointerException("discovery is marked non-null but is null");
        }
        if (watcher == null) {
            throw new NullPointerException("watcher is marked non-null but is null");
        }
        this.discovery = discovery;
        this.watcher = watcher;
    }
}

