/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.messaging;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.messaging.ErrorHandler;
import tr.com.infumia.infumialib.messaging.Portal;
import tr.com.infumia.infumialib.messaging.ServerSender;
import tr.com.infumia.infumialib.messaging.messengers.ServerMessenger;
import tr.com.infumia.infumialib.messaging.proto.Definitions;
import tr.com.infumia.infumialib.messaging.proto.Messaging;

public interface Travel {
    @NotNull
    public ErrorHandler errorHandler();

    public boolean isTravelling(@NotNull String var1);

    @NotNull
    default public Portal.BooleanResult sendRequest(@NotNull String type, @NotNull Definitions.OfflineUser source, @NotNull String data) {
        return Portal.get(type).map(portal -> portal.sendRequest(source, data)).orElse(new Portal.BooleanResult(Definitions.Error.newBuilder().setError("portal-not-found").addArgs(type).build(), null));
    }

    @NotNull
    public ServerMessenger serverMessenger();

    @NotNull
    public ServerSender serverSender();

    public static final class Result {
        @Nullable
        private final Definitions.Error error;
        @Nullable
        private final @Nullable Supplier< @NotNull Map.Entry< @Nullable Definitions.Position,  @Nullable Definitions.Error>> supplier;

        @Contract(value="null, null -> fail")
        public Result(@Nullable Definitions.Error error, @Nullable @Nullable Supplier< @NotNull Map.Entry< @Nullable Definitions.Position,  @Nullable Definitions.Error>> supplier) {
            Preconditions.checkState((error != null || supplier != null ? 1 : 0) != 0, (Object)"Both error and supplier are null!");
            this.error = error;
            this.supplier = supplier;
        }

        @Nullable
        public Definitions.Error error() {
            return this.error;
        }

        @Nullable
        public @Nullable Supplier< @NotNull Map.Entry< @Nullable Definitions.Position,  @Nullable Definitions.Error>> supplier() {
            return this.supplier;
        }
    }

    public record Response(@NotNull Supplier< @Nullable Definitions.Error> errorCatcher, long time, @NotNull String type) {
        public Response(@NotNull Supplier< @Nullable Definitions.Error> errorCatcher, @NotNull String type) {
            this(errorCatcher, System.currentTimeMillis(), type);
        }
    }

    public record Request(@NotNull Supplier<Pair< @Nullable Definitions.Position,  @Nullable Definitions.Error>> supplier, long time, @NotNull String type) {
        public Request(@NotNull Supplier<Pair< @Nullable Definitions.Position,  @Nullable Definitions.Error>> supplier, @NotNull String type) {
            this(supplier, System.currentTimeMillis(), type);
        }
    }

    public static abstract class Base
    implements Travel {
        @NotNull
        private final ErrorHandler errorHandler;
        @NotNull
        private final @NotNull Cache<@NotNull String, @NotNull Request> requests = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        @NotNull
        private final @NotNull Cache<@NotNull String, @NotNull Response> responses = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        @NotNull
        private final ServerMessenger serverMessenger;
        @NotNull
        private final ServerSender serverSender;
        @NotNull
        private final @NotNull Cache<@NotNull String, @NotNull String> transfer = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

        protected Base(@NotNull ServerMessenger serverMessenger, @NotNull ErrorHandler errorHandler, @NotNull ServerSender serverSender) {
            this.serverMessenger = serverMessenger;
            this.errorHandler = errorHandler;
            this.serverSender = serverSender;
            serverMessenger.subscribe(Messaging.Travel.Request.getDefaultInstance(), this::onRequest);
            serverMessenger.subscribe(Messaging.Travel.Response.getDefaultInstance(), this::onResponse);
        }

        @Override
        public final boolean isTravelling(@NotNull String uniqueId) {
            return this.transfer.asMap().containsKey(uniqueId);
        }

        private void onRequest(@NotNull Messaging.ServerMessage serverMessage, @NotNull Messaging.Travel.Request request) {
            String type = request.getType();
            Portal.get(type).ifPresentOrElse(portal -> {
                Optional deserialize = portal.deserialize(request.getValue().toByteArray());
                if (deserialize.isEmpty()) {
                    this.sendResponse(serverMessage, request, Definitions.Error.newBuilder().setError("unexpected-1").build());
                    return;
                }
                Portal.PositionResult result = portal.onRequest(request.getSource(), (String)deserialize.get());
                Definitions.Error error = result.error();
                Supplier<Pair<Definitions.Position, Definitions.Error>> supplier = result.supplier();
                if (supplier == null || error != null) {
                    this.sendResponse(serverMessage, request, error);
                    return;
                }
                this.requests.put((Object)request.getSource().getId(), (Object)new Request(supplier, portal.type()));
                this.sendResponse(serverMessage, request, null);
            }, () -> this.sendResponse(serverMessage, request, Definitions.Error.newBuilder().setError("portal-not-found").addArgs(type).build()));
        }

        private void onResponse(@NotNull Messaging.ServerMessage serverMessage, @NotNull Messaging.Travel.Response travelResponse) {
            String uniqueId = travelResponse.getSource().getId();
            Response response = (Response)this.responses.getIfPresent((Object)uniqueId);
            if (response == null) {
                this.errorHandler.onError(uniqueId, Definitions.Error.newBuilder().setError("response-not-found").build());
                return;
            }
            this.responses.invalidate((Object)uniqueId);
            boolean done = travelResponse.getDone();
            if (!done) {
                this.errorHandler.onError(uniqueId, travelResponse.getReason());
                return;
            }
            Definitions.Error caughtError = response.errorCatcher().get();
            if (caughtError != null) {
                this.errorHandler.onError(uniqueId, caughtError);
                return;
            }
            this.serverSender.send(uniqueId, serverMessage.getSource());
        }

        private void sendResponse(@NotNull Messaging.ServerMessage message, @NotNull Messaging.Travel.Request request, @Nullable Definitions.Error error) {
            Messaging.Travel.Response.Builder response = Messaging.Travel.Response.newBuilder().setSource(request.getSource()).setType(request.getType()).setDone(error == null);
            if (error != null) {
                response.setReason(error);
            }
            this.serverMessenger.publish(message.getSource(), response.build());
        }

        @Override
        @NotNull
        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        @Override
        @NotNull
        public ServerMessenger serverMessenger() {
            return this.serverMessenger;
        }

        @Override
        @NotNull
        public ServerSender serverSender() {
            return this.serverSender;
        }
    }
}

