/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.declarations;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.reflection.RefField;
import tr.com.infumia.infumialib.reflection.clazz.ClassOf;
import tr.com.infumia.infumialib.transformer.TransformedObject;
import tr.com.infumia.infumialib.transformer.annotations.Comment;
import tr.com.infumia.infumialib.transformer.annotations.Exclude;
import tr.com.infumia.infumialib.transformer.annotations.Names;
import tr.com.infumia.infumialib.transformer.annotations.Version;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;

public final class TransformedObjectDeclaration {
    @NotNull
    private final Map<String, FieldDeclaration> fields;
    @Nullable
    private final Comment header;
    @NotNull
    private final Class<?> objectClass;
    @Nullable
    private Version version;

    private TransformedObjectDeclaration(@NotNull Map<String, FieldDeclaration> fields, @Nullable Comment header, @NotNull Class<?> objectClass, @Nullable Version version) {
        this.fields = fields;
        this.header = header;
        this.objectClass = objectClass;
        this.version = version;
    }

    @NotNull
    public static TransformedObjectDeclaration of(@NotNull Class<?> cls, @Nullable TransformedObject object) {
        ClassOf classOf = new ClassOf(cls);
        LinkedHashMap<String, FieldDeclaration> map = new LinkedHashMap<String, FieldDeclaration>();
        for (RefField field : classOf.getDeclaredFields()) {
            if (field.getName().startsWith("this$") || field.hasAnnotation(Exclude.class)) continue;
            FieldDeclaration declaration = FieldDeclaration.of(Names.Calculated.calculateNames(cls), object, field);
            map.merge(declaration.getPath(), declaration, (f1, f2) -> {
                if (f1.getMigration() != null) {
                    return f2;
                }
                throw new IllegalStateException(String.format("Duplicate key %s", f1));
            });
        }
        return new TransformedObjectDeclaration(map, classOf.getAnnotation(Comment.class).orElse(null), cls, classOf.getAnnotation(Version.class).orElse(null));
    }

    @NotNull
    public static TransformedObjectDeclaration of(@NotNull TransformedObject object) {
        return TransformedObjectDeclaration.of(object.getClass(), object);
    }

    @NotNull
    public static TransformedObjectDeclaration of(@NotNull Class<?> cls) {
        return TransformedObjectDeclaration.of(cls, null);
    }

    @NotNull
    public Map<String, FieldDeclaration> getAllFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    @NotNull
    public Map<String, FieldDeclaration> getMigratedFields() {
        HashMap<String, FieldDeclaration> map = new HashMap<String, FieldDeclaration>();
        for (Map.Entry<String, FieldDeclaration> entry : this.fields.entrySet()) {
            if (!entry.getValue().isMigrated(this) || map.put(entry.getKey(), entry.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        return Collections.unmodifiableMap(map);
    }

    @NotNull
    public Map<String, FieldDeclaration> getNonMigratedFields() {
        HashMap<String, FieldDeclaration> map = new HashMap<String, FieldDeclaration>();
        for (Map.Entry<String, FieldDeclaration> entry : this.fields.entrySet()) {
            if (!entry.getValue().isNotMigrated(this) || map.put(entry.getKey(), entry.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        return map;
    }

    public int getVersionInteger() {
        return this.version == null ? 1 : this.version.value();
    }

    public String toString() {
        return "TransformedObjectDeclaration(fields=" + this.fields + ", header=" + this.getHeader() + ", objectClass=" + this.getObjectClass() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformedObjectDeclaration)) {
            return false;
        }
        TransformedObjectDeclaration other = (TransformedObjectDeclaration)o;
        Map<String, FieldDeclaration> this$fields = this.fields;
        Map<String, FieldDeclaration> other$fields = other.fields;
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Comment this$header = this.getHeader();
        Comment other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Class<?> this$objectClass = this.getObjectClass();
        Class<?> other$objectClass = other.getObjectClass();
        if (this$objectClass == null ? other$objectClass != null : !this$objectClass.equals(other$objectClass)) {
            return false;
        }
        Version this$version = this.getVersion();
        Version other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, FieldDeclaration> $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Comment $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Class<?> $objectClass = this.getObjectClass();
        result = result * 59 + ($objectClass == null ? 43 : $objectClass.hashCode());
        Version $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Nullable
    public Comment getHeader() {
        return this.header;
    }

    @NotNull
    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    @Nullable
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable Version version) {
        this.version = version;
    }
}

