/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.api.workload;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.api.workload.Workload;

public final class WorkloadThread
implements Runnable {
    private final Queue<Workload> deque = new ConcurrentLinkedQueue<Workload>();
    private final long maxNanosPerTick;
    private final long workThreadId;

    WorkloadThread(long workThreadId, long maxNanosPerTick) {
        this.workThreadId = workThreadId;
        this.maxNanosPerTick = maxNanosPerTick;
    }

    @Override
    public void run() {
        Workload workload;
        long stopTime = System.nanoTime() + this.maxNanosPerTick;
        Workload first = this.deque.poll();
        if (first == null) {
            return;
        }
        this.computeWorkload(first);
        while ((workload = this.deque.poll()) != null && System.nanoTime() <= stopTime) {
            this.computeWorkload(workload);
            if (first.reschedule() || !first.equals(workload)) continue;
            break;
        }
    }

    private void computeWorkload(@NotNull Workload workload) {
        if (workload.shouldExecute()) {
            workload.compute();
        }
        if (workload.reschedule()) {
            this.deque.add(workload);
        }
    }
}

