/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.api.workload;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypedDistributedTask<T>
implements Runnable {
    @Nullable
    private final Consumer<T> action;
    private final int distributionSize;
    @Nullable
    private final Predicate<T> escapeCondition;
    @NotNull
    private final List<LinkedList<Supplier<T>>> suppliedValueMatrix;
    private int currentPosition = 0;

    public TypedDistributedTask(@Nullable Consumer<T> action, @Nullable Predicate<T> escapeCondition, int distributionSize) {
        this.distributionSize = distributionSize;
        this.action = action;
        this.escapeCondition = escapeCondition;
        this.suppliedValueMatrix = new ArrayList<LinkedList<Supplier<T>>>(this.distributionSize);
        for (int index = 0; index < this.distributionSize; ++index) {
            this.suppliedValueMatrix.add(new LinkedList());
        }
    }

    public void add(@NotNull Supplier<T> workload) {
        LinkedList<Supplier<T>> smallestList = this.suppliedValueMatrix.get(0);
        for (int index = 0; index < this.distributionSize && smallestList.size() != 0; ++index) {
            LinkedList<Supplier<T>> next = this.suppliedValueMatrix.get(index);
            int size = next.size();
            if (size >= smallestList.size()) continue;
            smallestList = next;
        }
        smallestList.add(workload);
    }

    @Override
    public void run() {
        this.suppliedValueMatrix.get(this.currentPosition).removeIf(this::executeThenCheck);
        this.proceedPosition();
    }

    private boolean executeThenCheck(@NotNull Supplier<T> valueSupplier) {
        T value = valueSupplier.get();
        if (this.action != null) {
            this.action.accept(value);
        }
        return this.escapeCondition == null || this.escapeCondition.test(value);
    }

    private void proceedPosition() {
        if (++this.currentPosition == this.distributionSize) {
            this.currentPosition = 0;
        }
    }

    public static <T> TypedDistributedTaskBuilder<T> builder() {
        return new TypedDistributedTaskBuilder();
    }

    public static class TypedDistributedTaskBuilder<T> {
        private Consumer<T> action;
        private Predicate<T> escapeCondition;
        private int distributionSize;

        TypedDistributedTaskBuilder() {
        }

        public TypedDistributedTaskBuilder<T> action(@Nullable Consumer<T> action) {
            this.action = action;
            return this;
        }

        public TypedDistributedTaskBuilder<T> escapeCondition(@Nullable Predicate<T> escapeCondition) {
            this.escapeCondition = escapeCondition;
            return this;
        }

        public TypedDistributedTaskBuilder<T> distributionSize(int distributionSize) {
            this.distributionSize = distributionSize;
            return this;
        }

        public TypedDistributedTask<T> build() {
            return new TypedDistributedTask<T>(this.action, this.escapeCondition, this.distributionSize);
        }

        public String toString() {
            return "TypedDistributedTask.TypedDistributedTaskBuilder(action=" + this.action + ", escapeCondition=" + this.escapeCondition + ", distributionSize=" + this.distributionSize + ")";
        }
    }
}

