/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.api.input;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.api.input.ChatPlatform;
import tr.com.infumia.infumialib.api.input.ChatSender;
import tr.com.infumia.infumialib.api.input.ChatTask;
import tr.com.infumia.infumialib.api.input.EndReason;
import tr.com.infumia.infumialib.api.input.event.ChatEvent;
import tr.com.infumia.infumialib.api.input.event.QuitEvent;

public final class ChatInput<T, P> {
    @NotNull
    private final Builder<T, P> builder;
    @NotNull
    private final ChatPlatform<P> platform;
    private final AtomicBoolean started = new AtomicBoolean(false);
    @Nullable
    private ChatTask expireTask;

    @NotNull
    public static <T, P> Builder<T, P> builder(@NotNull ChatPlatform<P> platform, @NotNull ChatSender<P> sender) {
        return new Builder(platform, sender);
    }

    public void end(@NotNull P sender, @NotNull EndReason reason) {
        this.started.set(false);
        this.platform.unregisterListeners();
        Optional.ofNullable(this.expireTask).ifPresent(ChatTask::cancel);
        this.builder.getRunAfter().forEach((r, j) -> {
            if (r == reason) {
                j.forEach(c -> c.accept(sender));
            }
        });
    }

    public void onChat(@NotNull ChatEvent<P> event) {
        if (!this.started.get()) {
            return;
        }
        ChatSender<P> sender = this.builder.getSender();
        if (!sender.getUniqueId().equals(event.getSender().getUniqueId())) {
            return;
        }
        event.cancel();
        String message = event.getMessage();
        Object wrapped = sender.getWrapped();
        if (message.equalsIgnoreCase(this.builder.getCancel())) {
            try {
                this.builder.getOnCancel().accept(wrapped);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.end(wrapped, EndReason.PLAYER_CANCELS);
            return;
        }
        if (this.builder.getIsValidInput().test(wrapped, message)) {
            T value = this.builder.getSetValue().apply(wrapped, message);
            try {
                this.builder.getOnFinish().accept(wrapped, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.end(wrapped, EndReason.FINISH);
        } else {
            if (this.builder.getOnInvalidInput().test(wrapped, message)) {
                Optional.ofNullable(this.builder.getInvalidInputMessage()).ifPresent(sender::sendMessage);
                Optional.ofNullable(this.builder.getSendValueMessage()).filter(s -> this.builder.isRepeat()).ifPresent(sender::sendMessage);
            }
            if (!this.builder.isRepeat()) {
                this.end(wrapped, EndReason.INVALID_INPUT);
            }
        }
    }

    public void onQuit(@NotNull QuitEvent<P> event) {
        if (!this.started.get()) {
            return;
        }
        ChatSender<P> sender = this.builder.getSender();
        if (event.getSender().getUniqueId().equals(sender.getUniqueId())) {
            this.builder.getOnDisconnect().accept(sender.getWrapped());
            this.end(sender.getWrapped(), EndReason.PLAYER_DISCONNECTS);
        }
    }

    public void start() {
        this.platform.init(this);
        ChatSender sender = this.builder.getSender();
        if (this.builder.getExpire() != -1L) {
            this.expireTask = this.platform.createRunTaskLater(() -> {
                if (!this.started.get()) {
                    return;
                }
                Optional.ofNullable(this.expireTask).filter(task -> !task.isCancelled()).map(task -> sender.getWrapped()).ifPresent(wrapped -> {
                    this.builder.getOnExpire().accept(wrapped);
                    this.end(wrapped, EndReason.EXPIRE);
                });
            }, this.builder.getExpire());
        }
        this.started.set(true);
        Optional.ofNullable(this.builder.getSendValueMessage()).ifPresent(sender::sendMessage);
    }

    private ChatInput(@NotNull Builder<T, P> builder, @NotNull ChatPlatform<P> platform) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (platform == null) {
            throw new NullPointerException("platform is marked non-null but is null");
        }
        this.builder = builder;
        this.platform = platform;
    }

    public static final class Builder<T, P> {
        @NotNull
        private final ChatPlatform<P> platform;
        @NotNull
        private final EnumMap<EndReason, Collection<Consumer<P>>> runAfter = new EnumMap(EndReason.class);
        @NotNull
        private final ChatSender<P> sender;
        @NotNull
        private String cancel = "cancel";
        private long expire = -1L;
        @Nullable
        private Function<P, String> expireMessage;
        @Nullable
        private String invalidInputMessage = "That is not a valid input!";
        @NotNull
        private BiPredicate<P, String> isValidInput = (p, mes) -> true;
        @NotNull
        private Consumer<P> onCancel = p -> {};
        @NotNull
        private Consumer<P> onDisconnect = sender -> {};
        @NotNull
        private Consumer<P> onExpire = p -> {};
        @NotNull
        private BiConsumer<P, T> onFinish = (p, val) -> {};
        @NotNull
        private BiPredicate<P, String> onInvalidInput = (p, mes) -> true;
        private boolean repeat = true;
        @Nullable
        private String sendValueMessage = "Send in the chat the value";
        @Nullable
        private T value;
        @NotNull
        private BiFunction<P, String, T> setValue = (p, mes) -> this.value;

        @NotNull
        public Builder<T, P> addRunAfter(@NotNull Consumer<P> runAfter, EndReason ... reasons) {
            for (EndReason reason : reasons) {
                Collection old = this.runAfter.getOrDefault((Object)reason, new HashSet());
                old.add(runAfter);
                this.runAfter.put(reason, old);
            }
            return this;
        }

        @NotNull
        public ChatInput<T, P> build() {
            return new ChatInput(this, this.platform);
        }

        @NotNull
        public Builder<T, P> chainAfter(@NotNull Builder<T, P> builder, EndReason ... reasons) {
            return this.chainAfter(builder.build(), reasons);
        }

        @NotNull
        public Builder<T, P> chainAfter(@NotNull ChatInput<T, P> input, EndReason ... reasons) {
            ArrayList<EndReason> list = new ArrayList<EndReason>();
            for (EndReason reason : reasons) {
                if (reason == EndReason.PLAYER_DISCONNECTS) continue;
                list.add(reason);
            }
            return this.addRunAfter(sender -> input.start(), list.toArray(new EndReason[0]));
        }

        @NotNull
        public Builder<T, P> defaultValue(@Nullable T value) {
            this.value = value;
            return this;
        }

        @NotNull
        public Builder<T, P> expire(long expire) {
            this.expire = expire;
            return this;
        }

        @NotNull
        public Builder<T, P> invalidInputMessage(@Nullable String invalidInputMessage) {
            this.invalidInputMessage = invalidInputMessage;
            return this;
        }

        @NotNull
        public Builder<T, P> isValidInput(@NotNull BiPredicate<P, String> isValidInput) {
            this.isValidInput = isValidInput;
            return this;
        }

        @NotNull
        public Builder<T, P> onCancel(@NotNull Consumer<P> onCancel) {
            this.onCancel = onCancel;
            return this;
        }

        @NotNull
        public Builder<T, P> onDisconnect(@NotNull Consumer<P> onDisconnect) {
            this.onDisconnect = onDisconnect;
            return this;
        }

        @NotNull
        public Builder<T, P> onExpire(@NotNull Consumer<P> onExpire) {
            this.onExpire = onExpire;
            return this;
        }

        @NotNull
        public Builder<T, P> onFinish(@NotNull BiConsumer<P, T> onFinish) {
            this.onFinish = onFinish;
            return this;
        }

        @NotNull
        public Builder<T, P> onInvalidInput(@NotNull BiPredicate<P, String> onInvalidInput) {
            this.onInvalidInput = onInvalidInput;
            return this;
        }

        @NotNull
        public Builder<T, P> repeat(boolean repeat) {
            this.repeat = repeat;
            return this;
        }

        @NotNull
        public Builder<T, P> sendValueMessage(@Nullable String sendValueMessage) {
            this.sendValueMessage = sendValueMessage;
            return this;
        }

        @NotNull
        public Builder<T, P> setExpireMessage(@NotNull Function<P, String> expireMessage) {
            this.expireMessage = expireMessage;
            return this;
        }

        @NotNull
        public Builder<T, P> setValue(@NotNull BiFunction<P, String, T> setValue) {
            this.setValue = setValue;
            return this;
        }

        @NotNull
        public Builder<T, P> toCancel(@NotNull String cancel) {
            this.cancel = cancel;
            return this;
        }

        @NotNull
        public ChatPlatform<P> getPlatform() {
            return this.platform;
        }

        @NotNull
        public EnumMap<EndReason, Collection<Consumer<P>>> getRunAfter() {
            return this.runAfter;
        }

        @NotNull
        public ChatSender<P> getSender() {
            return this.sender;
        }

        @NotNull
        public String getCancel() {
            return this.cancel;
        }

        public long getExpire() {
            return this.expire;
        }

        @Nullable
        public Function<P, String> getExpireMessage() {
            return this.expireMessage;
        }

        @Nullable
        public String getInvalidInputMessage() {
            return this.invalidInputMessage;
        }

        @NotNull
        public BiPredicate<P, String> getIsValidInput() {
            return this.isValidInput;
        }

        @NotNull
        public Consumer<P> getOnCancel() {
            return this.onCancel;
        }

        @NotNull
        public Consumer<P> getOnDisconnect() {
            return this.onDisconnect;
        }

        @NotNull
        public Consumer<P> getOnExpire() {
            return this.onExpire;
        }

        @NotNull
        public BiConsumer<P, T> getOnFinish() {
            return this.onFinish;
        }

        @NotNull
        public BiPredicate<P, String> getOnInvalidInput() {
            return this.onInvalidInput;
        }

        public boolean isRepeat() {
            return this.repeat;
        }

        @Nullable
        public String getSendValueMessage() {
            return this.sendValueMessage;
        }

        @Nullable
        public T getValue() {
            return this.value;
        }

        @NotNull
        public BiFunction<P, String, T> getSetValue() {
            return this.setValue;
        }

        private Builder(@NotNull ChatPlatform<P> platform, @NotNull ChatSender<P> sender2) {
            if (platform == null) {
                throw new NullPointerException("platform is marked non-null but is null");
            }
            if (sender2 == null) {
                throw new NullPointerException("sender is marked non-null but is null");
            }
            this.platform = platform;
            this.sender = sender2;
        }
    }
}

