/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.http;

import com.google.protobuf.GeneratedMessageV3;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProtobufHttp {
    @NotNull
    private final HttpClient client;

    @NotNull
    static ProtobufHttp create() {
        return new ProtobufHttp(HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(20L)).build());
    }

    boolean delete(@NotNull String url) {
        HttpRequest request = HttpRequest.newBuilder().DELETE().uri(URI.create(url)).build();
        try {
            return this.client.send(request, HttpResponse.BodyHandlers.ofString()).statusCode() == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    <T extends GeneratedMessageV3> T get(@NotNull String url, @NotNull T defaultInstance) {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(url)).build();
        try {
            HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() == 200) {
                return (T)defaultInstance.getParserForType().parseFrom(response.body());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    <T extends GeneratedMessageV3, B extends GeneratedMessageV3> T post(@NotNull String url, @NotNull T defaultInstance, @NotNull B body) {
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofByteArray(body.toByteArray())).uri(URI.create(url)).build();
        try {
            HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() == 200) {
                return (T)defaultInstance.getParserForType().parseFrom(response.body());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    <T extends GeneratedMessageV3> boolean post(@NotNull String url, @NotNull T body) {
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofByteArray(body.toByteArray())).uri(URI.create(url)).build();
        try {
            return this.client.send(request, HttpResponse.BodyHandlers.ofInputStream()).statusCode() == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private ProtobufHttp(@NotNull HttpClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }
}

