/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.http;

import com.google.protobuf.GeneratedMessageV3;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.http.ProtobufHttp;

public abstract class AsyncHttpApi {
    @NotNull
    private final String address;
    @NotNull
    private final String path;

    @NotNull
    protected final CompletableFuture<Boolean> delete(@NotNull String path) {
        return CompletableFuture.supplyAsync(() -> ProtobufHttp.create().delete(this.path(path)));
    }

    @NotNull
    protected final <T extends GeneratedMessageV3> CompletableFuture<T> get(@NotNull String path, @NotNull T defaultInstance) {
        return CompletableFuture.supplyAsync(() -> ProtobufHttp.create().get(this.path(path), defaultInstance));
    }

    @NotNull
    protected final <T extends GeneratedMessageV3> CompletableFuture<Boolean> post(@NotNull String path, @NotNull T defaultInstance) {
        return CompletableFuture.supplyAsync(() -> ProtobufHttp.create().post(this.path(path), defaultInstance));
    }

    @NotNull
    protected final <T extends GeneratedMessageV3, B extends GeneratedMessageV3> CompletableFuture<T> post(@NotNull String path, @NotNull T defaultInstance, @NotNull B body) {
        return CompletableFuture.supplyAsync(() -> ProtobufHttp.create().post(this.path(path), defaultInstance, body));
    }

    private String path(@NotNull String s) {
        return String.format("%s/%s/%s", this.address, this.path, s);
    }

    protected AsyncHttpApi(@NotNull String address, @NotNull String path) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.address = address;
        this.path = path;
    }
}

