/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders.impl;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.FieldLoader;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.GenericFieldLoader;
import io.github.portlek.configs.util.NumberConversions;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlInetSocketAddress
extends GenericFieldLoader<String, InetSocketAddress> {
    public static final FieldLoader.Func INSTANCE = FlInetSocketAddress::new;

    private FlInetSocketAddress(@NotNull ConfigHolder holder, @NotNull ConfigurationSection section) {
        super(holder, section, InetSocketAddress.class);
    }

    @NotNull
    private static Optional<InetSocketAddress> convertToAddress(@Nullable String raw) {
        if (raw == null) {
            return Optional.empty();
        }
        String trim = raw.trim();
        String[] strings = trim.split(":");
        if (strings.length != 2) {
            return Optional.empty();
        }
        return Optional.of(new InetSocketAddress(strings[0], NumberConversions.toInt(strings[1], 1)));
    }

    @Override
    @NotNull
    public Optional<String> toConfigObject(@NotNull ConfigurationSection section, @NotNull String path) {
        return Optional.ofNullable(section.getString(path));
    }

    @Override
    @NotNull
    public Optional<InetSocketAddress> toFinal(@NotNull String rawValue, @Nullable InetSocketAddress fieldValue) {
        return FlInetSocketAddress.convertToAddress(rawValue);
    }

    @Override
    @NotNull
    public Optional<String> toRaw(@NotNull InetSocketAddress finalValue) {
        return Optional.of(finalValue.getHostName() + ":" + finalValue.getPort());
    }
}

