/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.ConfigLoader;
import io.github.portlek.configs.ConfigType;
import io.github.portlek.configs.FieldLoader;
import io.github.portlek.configs.Loader;
import java.io.File;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LangLoader
implements Loader {
    @NotNull
    public final Executor asyncExecutor;
    @NotNull
    private final Map<String, ConfigLoader.Builder> builders;
    private final StringLoaderEntry[] built;
    @Nullable
    private final ConfigHolder configHolder;
    private final AtomicInteger statement = new AtomicInteger();
    @Nullable
    private String defaultLanguage;
    @Nullable
    private List<String> keys;
    @Nullable
    private List<ConfigLoader.Builder> values;

    private LangLoader(@NotNull Executor asyncExecutor, @NotNull Map<String, ConfigLoader.Builder> builders, @Nullable ConfigHolder configHolder) {
        this.asyncExecutor = asyncExecutor;
        this.builders = builders;
        this.configHolder = configHolder;
        this.built = new StringLoaderEntry[this.builders.size()];
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StringLoaderEntry[] getBuilt() {
        StringLoaderEntry[] stringLoaderEntryArray = this.built;
        synchronized (this.built) {
            if (this.built.length == 0) {
                throw new IllegalStateException("Couldn't find any built config loader instance.");
            }
            if (this.built[0] == null) {
                List list = this.builders.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, ConfigLoader>((String)entry.getKey(), ((ConfigLoader.Builder)entry.getValue()).build())).collect(Collectors.toList());
                IntStream.range(0, list.size()).forEach(index -> {
                    this.built[index] = new StringLoaderEntry((Map.Entry)list.get(index));
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (StringLoaderEntry[])this.built.clone();
        }
    }

    @NotNull
    public Optional<String> getDefaultLanguage() {
        if (this.defaultLanguage == null) {
            this.defaultLanguage = this.getKeys().stream().findFirst().orElse(null);
        }
        return Optional.ofNullable(this.defaultLanguage);
    }

    @Override
    public int getFileVersion() {
        return this.pollConfigLoader().getValue().getFileVersion();
    }

    @Override
    @NotNull
    public Map<Integer, Consumer<Loader>> getFileVersionOperations() {
        return this.pollConfigLoader().getValue().getFileVersionOperations();
    }

    @NotNull
    public List<String> getKeys() {
        if (this.keys == null) {
            this.keys = List.copyOf(this.builders.keySet());
        }
        return Collections.unmodifiableList(this.keys);
    }

    @NotNull
    public List<ConfigLoader.Builder> getValues() {
        if (this.values == null) {
            this.values = List.copyOf(this.builders.values());
        }
        return Collections.unmodifiableList(this.values);
    }

    @NotNull
    public LangLoader load(boolean save) {
        return this.load(save, false).join();
    }

    @NotNull
    public CompletableFuture<LangLoader> load(boolean save, boolean async) {
        CompletableFuture<LangLoader> future = new CompletableFuture<LangLoader>();
        Function<ConfigLoader, Runnable> job = loader -> () -> {
            loader.createFolderAndFile();
            loader.loadFile();
            this.loadFieldsAndSave((ConfigLoader)loader, save);
        };
        Arrays.stream(this.getBuilt()).map(StringLoaderEntry::getValue).forEach(built -> {
            if (async) {
                future.thenRunAsync((Runnable)job.apply((ConfigLoader)built), built.getAsyncExecutor());
            } else {
                future.thenRun((Runnable)job.apply((ConfigLoader)built));
            }
        });
        if (async) {
            future.completeAsync(() -> this, this.asyncExecutor);
        } else {
            future.complete(this);
        }
        return future;
    }

    @NotNull
    public LangLoader load() {
        return this.load(false);
    }

    @NotNull
    public Map.Entry<String, ConfigLoader> pollConfigLoader() {
        StringLoaderEntry[] built = this.getBuilt();
        if (built.length == 0) {
            throw new IllegalStateException("Couldn't find any built config loader.");
        }
        return built[this.pollStatement()];
    }

    private void loadFieldsAndSave(@NotNull ConfigLoader configLoader, boolean save) {
        if (this.configHolder != null) {
            FieldLoader.load(this, this.configHolder, configLoader.getLoaders());
        }
        if (save) {
            configLoader.save();
        }
    }

    private int pollStatement() {
        if (this.statement.get() > this.getKeys().size()) {
            this.statement.set(0);
        }
        return this.statement.getAndIncrement();
    }

    @NotNull
    public Executor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @NotNull
    public Map<String, ConfigLoader.Builder> getBuilders() {
        return this.builders;
    }

    @Override
    @Nullable
    public ConfigHolder getConfigHolder() {
        return this.configHolder;
    }

    public AtomicInteger getStatement() {
        return this.statement;
    }

    public static final class StringLoaderEntry
    implements Map.Entry<String, ConfigLoader> {
        @NotNull
        private final Map.Entry<String, ConfigLoader> original;

        public StringLoaderEntry(@NotNull Map.Entry<String, ConfigLoader> original) {
            if (original == null) {
                throw new NullPointerException("original is marked non-null but is null");
            }
            this.original = original;
        }

        @Override
        public String getKey() {
            return this.original.getKey();
        }

        @Override
        public ConfigLoader getValue() {
            return this.original.getValue();
        }

        @Override
        public ConfigLoader setValue(ConfigLoader arg0) {
            return this.original.setValue(arg0);
        }
    }

    public static final class Builder {
        @NotNull
        private Executor asyncExecutor = Executors.newWorkStealingPool();
        @NotNull
        private Map<String, ConfigLoader.Builder> builders = new HashMap<String, ConfigLoader.Builder>();
        @Nullable
        private ConfigHolder holder;

        @SafeVarargs
        @NotNull
        public final Builder addBuilder(Map.Entry<String, ConfigLoader.Builder> ... builders) {
            Arrays.stream(builders).forEach(builder -> this.builders.put((String)builder.getKey(), (ConfigLoader.Builder)builder.getValue()));
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder setBuilders(Map.Entry<String, ConfigLoader.Builder> ... builders) {
            this.builders = Arrays.stream(builders).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, HashMap::new));
            return this;
        }

        @NotNull
        public Builder addBuilder(@NotNull String fileName, @NotNull Path folder, @NotNull ConfigType configType) {
            this.builders.put(fileName, ConfigLoader.builderForLang(fileName, folder, configType));
            return this;
        }

        @NotNull
        public Builder addBuilder(@NotNull String key, @NotNull String fileName, @NotNull Path folder, @NotNull ConfigType configType) {
            this.builders.put(key, ConfigLoader.builderForLang(fileName, folder, configType));
            return this;
        }

        @NotNull
        public Builder addBuilder(@NotNull String fileName, @NotNull File folder, @NotNull ConfigType configType) {
            this.builders.put(fileName, ConfigLoader.builderForLang(fileName, folder, configType));
            return this;
        }

        @NotNull
        public Builder addBuilder(@NotNull String key, @NotNull String fileName, @NotNull File folder, @NotNull ConfigType configType) {
            this.builders.put(key, ConfigLoader.builderForLang(fileName, folder, configType));
            return this;
        }

        @NotNull
        public Builder addBuilder(@NotNull ConfigLoader.Builder builder) {
            String key = builder.getFileName();
            if (key == null) {
                return this;
            }
            this.builders.put(key, builder);
            return this;
        }

        @NotNull
        public Builder addBuilder(@NotNull String key, @NotNull ConfigLoader.Builder builder) {
            this.builders.put(key, builder);
            return this;
        }

        @NotNull
        public Builder addBuilder(@NotNull Map<String, ConfigLoader.Builder> builders) {
            this.builders.putAll(builders);
            return this;
        }

        @NotNull
        public LangLoader build() {
            if (this.builders.isEmpty()) {
                throw new IllegalStateException("#builders is empty");
            }
            if (this.holder != null) {
                this.builders.values().forEach(builder -> builder.setConfigHolder(this.holder));
            }
            return new LangLoader(this.asyncExecutor, this.builders, this.holder);
        }

        @NotNull
        public Builder setAsyncExecutor(@NotNull Executor asyncExecutor) {
            this.asyncExecutor = asyncExecutor;
            return this;
        }

        @NotNull
        public Builder setBuilders(@NotNull Map<String, ConfigLoader.Builder> builders) {
            this.builders = builders;
            return this;
        }

        @NotNull
        public Builder setHolder(@NotNull ConfigHolder holder) {
            this.holder = holder;
            return this;
        }

        @NotNull
        public Executor getAsyncExecutor() {
            return this.asyncExecutor;
        }

        @NotNull
        public Map<String, ConfigLoader.Builder> getBuilders() {
            return this.builders;
        }

        @Nullable
        public ConfigHolder getHolder() {
            return this.holder;
        }

        private Builder() {
        }
    }
}

