/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.impl;

import com.mongodb.internal.connection.tlschannel.BufferAllocator;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferHolder {
    private static final Logger logger = LoggerFactory.getLogger(BufferHolder.class);
    private static final byte[] zeros = new byte[17408];
    public final String name;
    public final BufferAllocator allocator;
    public final boolean plainData;
    public final int maxSize;
    public final boolean opportunisticDispose;
    public ByteBuffer buffer;
    public int lastSize;

    public BufferHolder(String name, Optional<ByteBuffer> buffer, BufferAllocator allocator, int initialSize, int maxSize, boolean plainData, boolean opportunisticDispose) {
        this.name = name;
        this.allocator = allocator;
        this.buffer = buffer.orElse(null);
        this.maxSize = maxSize;
        this.plainData = plainData;
        this.opportunisticDispose = opportunisticDispose;
        this.lastSize = buffer.map(b -> b.capacity()).orElse(initialSize);
    }

    public void prepare() {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate(this.lastSize);
        }
    }

    public boolean release() {
        if (this.opportunisticDispose && this.buffer.position() == 0) {
            return this.dispose();
        }
        return false;
    }

    public boolean dispose() {
        if (this.buffer != null) {
            this.allocator.free(this.buffer);
            this.buffer = null;
            return true;
        }
        return false;
    }

    public void resize(int newCapacity) {
        if (newCapacity > this.maxSize) {
            throw new IllegalArgumentException(String.format("new capacity (%s) bigger than absolute max size (%s)", newCapacity, this.maxSize));
        }
        logger.trace("resizing buffer {}, increasing from {} to {} (manual sizing)", this.name, this.buffer.capacity(), newCapacity);
        this.resizeImpl(newCapacity);
    }

    public void enlarge() {
        if (this.buffer.capacity() >= this.maxSize) {
            throw new IllegalStateException(String.format("%s buffer insufficient despite having capacity of %d", this.name, this.buffer.capacity()));
        }
        int newCapacity = Math.min(this.buffer.capacity() * 2, this.maxSize);
        logger.trace("enlarging buffer {}, increasing from {} to {} (automatic enlarge)", this.name, this.buffer.capacity(), newCapacity);
        this.resizeImpl(newCapacity);
    }

    private void resizeImpl(int newCapacity) {
        ByteBuffer newBuffer = this.allocator.allocate(newCapacity);
        ((Buffer)this.buffer).flip();
        newBuffer.put(this.buffer);
        if (this.plainData) {
            this.zero();
        }
        this.allocator.free(this.buffer);
        this.buffer = newBuffer;
        this.lastSize = newCapacity;
    }

    public void zeroRemaining() {
        this.zero(this.buffer.position());
    }

    public void zero() {
        this.zero(0);
    }

    private void zero(int position) {
        ((Buffer)this.buffer).mark();
        ((Buffer)this.buffer).position(position);
        int size = this.buffer.remaining();
        int length = Math.min(size, zeros.length);
        int offset = 0;
        while (length > 0) {
            this.buffer.put(zeros, 0, length);
            length = Math.min(size - (offset += length), zeros.length);
        }
        ((Buffer)this.buffer).reset();
    }

    public boolean nullOrEmpty() {
        return this.buffer == null || this.buffer.position() == 0;
    }
}

