/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.nbt.stream;

import com.flowpowered.nbt.ByteArrayTag;
import com.flowpowered.nbt.ByteTag;
import com.flowpowered.nbt.CompoundTag;
import com.flowpowered.nbt.DoubleTag;
import com.flowpowered.nbt.EndTag;
import com.flowpowered.nbt.FloatTag;
import com.flowpowered.nbt.IntArrayTag;
import com.flowpowered.nbt.IntTag;
import com.flowpowered.nbt.ListTag;
import com.flowpowered.nbt.LongArrayTag;
import com.flowpowered.nbt.LongTag;
import com.flowpowered.nbt.ShortArrayTag;
import com.flowpowered.nbt.ShortTag;
import com.flowpowered.nbt.StringTag;
import com.flowpowered.nbt.Tag;
import com.flowpowered.nbt.TagType;
import com.flowpowered.nbt.stream.LittleEndianOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public final class NBTOutputStream
implements Closeable {
    private final DataOutput dataOut;
    private final OutputStream outputStream;

    public NBTOutputStream(OutputStream os) throws IOException {
        this(os, 1, ByteOrder.BIG_ENDIAN);
    }

    public NBTOutputStream(OutputStream os, int compression) throws IOException {
        this(os, compression, ByteOrder.BIG_ENDIAN);
    }

    public NBTOutputStream(OutputStream os, int compression, ByteOrder endianness) throws IOException {
        switch (compression) {
            case 0: {
                break;
            }
            case 1: {
                os = new GZIPOutputStream(os);
                break;
            }
            case 2: {
                os = new DeflaterOutputStream(os);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported compression type, must be between 0 and 2 (inclusive)");
            }
        }
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            this.dataOut = new LittleEndianOutputStream(os);
            this.outputStream = (OutputStream)((Object)this.dataOut);
        } else {
            this.dataOut = new DataOutputStream(os);
            this.outputStream = (OutputStream)((Object)this.dataOut);
        }
    }

    public void writeTag(Tag<?> tag) throws IOException {
        String name = tag.getName();
        this.dataOut.writeByte(tag.getType().getId());
        this.dataOut.writeUTF(name);
        if (tag.getType() == TagType.TAG_END) {
            throw new IOException("Named TAG_End not permitted.");
        }
        this.writeTagPayload(tag);
    }

    private void writeTagPayload(Tag<?> tag) throws IOException {
        switch (tag.getType()) {
            case TAG_END: {
                this.writeEndTagPayload((EndTag)tag);
                break;
            }
            case TAG_BYTE: {
                this.writeByteTagPayload((ByteTag)tag);
                break;
            }
            case TAG_SHORT: {
                this.writeShortTagPayload((ShortTag)tag);
                break;
            }
            case TAG_INT: {
                this.writeIntTagPayload((IntTag)tag);
                break;
            }
            case TAG_LONG: {
                this.writeLongTagPayload((LongTag)tag);
                break;
            }
            case TAG_FLOAT: {
                this.writeFloatTagPayload((FloatTag)tag);
                break;
            }
            case TAG_DOUBLE: {
                this.writeDoubleTagPayload((DoubleTag)tag);
                break;
            }
            case TAG_BYTE_ARRAY: {
                this.writeByteArrayTagPayload((ByteArrayTag)tag);
                break;
            }
            case TAG_STRING: {
                this.writeStringTagPayload((StringTag)tag);
                break;
            }
            case TAG_LIST: {
                this.writeListTagPayload((ListTag)tag);
                break;
            }
            case TAG_COMPOUND: {
                this.writeCompoundTagPayload((CompoundTag)tag);
                break;
            }
            case TAG_INT_ARRAY: {
                this.writeIntArrayTagPayload((IntArrayTag)tag);
                break;
            }
            case TAG_LONG_ARRAY: {
                this.writeLongArrayTagPayload((LongArrayTag)tag);
                break;
            }
            case TAG_SHORT_ARRAY: {
                this.writeShortArrayTagPayload((ShortArrayTag)tag);
                break;
            }
            default: {
                throw new IOException("Invalid tag type: " + (Object)((Object)tag.getType()) + ".");
            }
        }
    }

    private void writeByteTagPayload(ByteTag tag) throws IOException {
        this.dataOut.writeByte(tag.getValue().byteValue());
    }

    private void writeByteArrayTagPayload(ByteArrayTag tag) throws IOException {
        byte[] bytes = tag.getValue();
        this.dataOut.writeInt(bytes.length);
        this.dataOut.write(bytes);
    }

    private void writeCompoundTagPayload(CompoundTag tag) throws IOException {
        for (Tag<?> childTag : tag.getValue().values()) {
            this.writeTag(childTag);
        }
        this.dataOut.writeByte(TagType.TAG_END.getId());
    }

    private void writeListTagPayload(ListTag<?> tag) throws IOException {
        Object tags = tag.getValue();
        int size = tags.size();
        this.dataOut.writeByte(tag.getElementType().getId());
        this.dataOut.writeInt(size);
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            Tag tag1 = (Tag)iterator.next();
            this.writeTagPayload(tag1);
        }
    }

    private void writeStringTagPayload(StringTag tag) throws IOException {
        this.dataOut.writeUTF(tag.getValue());
    }

    private void writeDoubleTagPayload(DoubleTag tag) throws IOException {
        this.dataOut.writeDouble(tag.getValue());
    }

    private void writeFloatTagPayload(FloatTag tag) throws IOException {
        this.dataOut.writeFloat(tag.getValue().floatValue());
    }

    private void writeLongTagPayload(LongTag tag) throws IOException {
        this.dataOut.writeLong(tag.getValue());
    }

    private void writeIntTagPayload(IntTag tag) throws IOException {
        this.dataOut.writeInt(tag.getValue());
    }

    private void writeShortTagPayload(ShortTag tag) throws IOException {
        this.dataOut.writeShort(tag.getValue().shortValue());
    }

    private void writeIntArrayTagPayload(IntArrayTag tag) throws IOException {
        int[] ints = tag.getValue();
        this.dataOut.writeInt(ints.length);
        for (int i = 0; i < ints.length; ++i) {
            this.dataOut.writeInt(ints[i]);
        }
    }

    private void writeLongArrayTagPayload(LongArrayTag tag) throws IOException {
        long[] longs = tag.getValue();
        this.dataOut.writeInt(longs.length);
        for (int i = 0; i < longs.length; ++i) {
            this.dataOut.writeLong(longs[i]);
        }
    }

    private void writeShortArrayTagPayload(ShortArrayTag tag) throws IOException {
        short[] shorts = tag.getValue();
        this.dataOut.writeInt(shorts.length);
        for (int i = 0; i < shorts.length; ++i) {
            this.dataOut.writeShort(shorts[i]);
        }
    }

    private void writeEndTagPayload(EndTag tag) {
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }
}

