/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.constructor;

import io.github.portlek.reflection.RefConstructed;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class ConstructorOf<T>
implements RefConstructed<T> {
    private static final Logger log = Logger.getLogger(ConstructorOf.class.getName());
    @NotNull
    private final Constructor<T> constructor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Optional<T> create(Object ... parameters) {
        boolean accessible = this.constructor.isAccessible();
        try {
            this.constructor.setAccessible(true);
            Optional<T> optional = Optional.of(this.constructor.newInstance(parameters));
            return optional;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            log.log(Level.SEVERE, "ConstructorOf#create(Object[])", exception);
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            this.constructor.setAccessible(accessible);
        }
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.constructor.getDeclaredAnnotation(annotationClass));
    }

    @Override
    public boolean hasFinal() {
        return Modifier.isFinal(this.constructor.getModifiers());
    }

    @Override
    public boolean hasPrivate() {
        return Modifier.isPrivate(this.constructor.getModifiers());
    }

    @Override
    public boolean hasPublic() {
        return Modifier.isPublic(this.constructor.getModifiers());
    }

    @Override
    public boolean hasStatic() {
        return Modifier.isStatic(this.constructor.getModifiers());
    }

    public ConstructorOf(@NotNull Constructor<T> constructor) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        this.constructor = constructor;
    }
}

