/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.json;

import io.github.portlek.configs.ConfigType;
import io.github.portlek.configs.configuration.FileConfiguration;
import io.github.portlek.configs.exceptions.InvalidConfigurationException;
import io.github.portlek.configs.json.Json;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class JsonType
implements ConfigType {
    private static final JsonType INSTANCE = new JsonType();

    @NotNull
    public static JsonType get() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getSuffix() {
        return ".json";
    }

    @Override
    @NotNull
    public FileConfiguration load(@NotNull File file) throws IOException, InvalidConfigurationException {
        Json json = new Json();
        json.load(file);
        return json;
    }

    @Override
    public void save(@NotNull File file, @NotNull FileConfiguration configuration) throws IOException {
        configuration.save(file);
    }
}

