/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.configuration;

import io.github.portlek.configs.configuration.Configuration;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.util.NumberConversions;
import io.github.portlek.configs.util.Validate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemorySection
implements ConfigurationSection {
    protected final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private final String fullPath;
    private final ConfigurationSection parent;
    private final String path;
    private final Configuration root;

    protected MemorySection() {
        if (!(this instanceof Configuration)) {
            throw new IllegalStateException("Cannot construct a root MemorySection when not a Configuration");
        }
        this.path = "";
        this.fullPath = "";
        this.parent = null;
        this.root = (Configuration)((Object)this);
    }

    protected MemorySection(@NotNull ConfigurationSection parent, @NotNull String path) {
        this.path = path;
        this.parent = parent;
        this.root = parent.getRoot();
        Validate.checkNull(this.root, "Path cannot be orphaned", new Object[0]);
        this.fullPath = MemorySection.createPath(parent, path);
    }

    public static String createPath(@NotNull ConfigurationSection section, @NotNull String key) {
        return MemorySection.createPath(section, key, section.getRoot());
    }

    public static String createPath(@NotNull ConfigurationSection section, String key, ConfigurationSection relativeTo) {
        Configuration root = section.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot create path without a root");
        }
        char separator = root.options().pathSeparator();
        StringBuilder builder = new StringBuilder();
        Stream.iterate(section, parent -> parent != null && parent != relativeTo, ConfigurationSection::getParent).forEach(parent -> {
            if (builder.length() > 0) {
                builder.insert(0, separator);
            }
            builder.insert(0, parent.getName());
        });
        if (key != null && key.length() > 0) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(key);
        }
        return builder.toString();
    }

    @Override
    public void addDefault(@NotNull String path, Object value) {
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot add default without root");
        }
        if (root == this) {
            throw new UnsupportedOperationException("Unsupported addDefault(String, Object) implementation");
        }
        root.addDefault(MemorySection.createPath(this, path), value);
    }

    @Override
    public boolean contains(@NotNull String path) {
        return this.get(path) != null;
    }

    @Override
    public boolean contains(@NotNull String path, boolean ignoreDefault) {
        return (ignoreDefault ? this.get(path, null) : this.get(path)) != null;
    }

    @Override
    @NotNull
    public ConfigurationSection createSection(@NotNull String path) {
        int i2;
        Validate.checkEmpty(path, "Cannot create section at empty path");
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot create section without a root");
        }
        char separator = root.options().pathSeparator();
        int i1 = -1;
        ConfigurationSection section = this;
        while ((i1 = path.indexOf(separator, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            ConfigurationSection subSection = section.getConfigurationSection(node);
            if (subSection == null) {
                section = section.createSection(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        if (section == this) {
            MemorySection result = new MemorySection(this, key);
            this.map.put(key, result);
            return result;
        }
        return section.createSection(key);
    }

    @Override
    @NotNull
    public ConfigurationSection createSection(@NotNull String path, @NotNull Map<?, ?> map) {
        ConfigurationSection section = this.createSection(path);
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                section.createSection(key.toString(), (Map)value);
            } else {
                section.set(key.toString(), value);
            }
        });
        return section;
    }

    @Override
    public Object get(@NotNull String path) {
        return this.get(path, this.getDefault(path));
    }

    @Override
    @Nullable
    public Object get(@NotNull String path, @Nullable Object def) {
        int i2;
        if (path.length() == 0) {
            return this;
        }
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot access section without a root");
        }
        char separator = root.options().pathSeparator();
        int i1 = -1;
        ConfigurationSection section = this;
        while ((i1 = path.indexOf(separator, i2 = i1 + 1)) != -1) {
            if ((section = section.getConfigurationSection(path.substring(i2, i1))) != null) continue;
            return def;
        }
        String key = path.substring(i2);
        if (section == this) {
            Object result = this.map.get(key);
            return result == null ? def : result;
        }
        return section.get(key, def);
    }

    @Override
    public boolean getBoolean(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getBoolean(path, def instanceof Boolean ? (Boolean)def : false);
    }

    @Override
    public boolean getBoolean(@NotNull String path, boolean def) {
        Object val = this.get(path, def);
        return val instanceof Boolean ? (Boolean)val : def;
    }

    @Override
    @NotNull
    public List<Boolean> getBooleanList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Boolean>(0);
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        list.forEach(object -> {
            if (object instanceof Boolean) {
                result.add((Boolean)object);
            } else if (object instanceof String) {
                if (Boolean.TRUE.toString().equals(object)) {
                    result.add(true);
                } else if (Boolean.FALSE.toString().equals(object)) {
                    result.add(false);
                }
            }
        });
        return result;
    }

    @Override
    @NotNull
    public List<Byte> getByteList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Byte>(0);
        }
        ArrayList<Byte> result = new ArrayList<Byte>();
        list.forEach(object -> {
            if (object instanceof Byte) {
                result.add((Byte)object);
            } else if (object instanceof String) {
                try {
                    result.add(Byte.valueOf((String)object));
                }
                catch (Exception exception) {}
            } else if (object instanceof Character) {
                result.add((byte)((Character)object).charValue());
            } else if (object instanceof Number) {
                result.add(((Number)object).byteValue());
            }
        });
        return result;
    }

    @Override
    @NotNull
    public List<Character> getCharacterList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Character>(0);
        }
        ArrayList<Character> result = new ArrayList<Character>();
        list.forEach(object -> {
            if (object instanceof Character) {
                result.add((Character)object);
            } else if (object instanceof String) {
                String str = (String)object;
                if (str.length() == 1) {
                    result.add(Character.valueOf(str.charAt(0)));
                }
            } else if (object instanceof Number) {
                result.add(Character.valueOf((char)((Number)object).intValue()));
            }
        });
        return result;
    }

    @Override
    public ConfigurationSection getConfigurationSection(@NotNull String path) {
        Object val = this.get(path, null);
        if (val != null) {
            return val instanceof ConfigurationSection ? (ConfigurationSection)val : null;
        }
        val = this.get(path, this.getDefault(path));
        return val instanceof ConfigurationSection ? this.createSection(path) : null;
    }

    @Override
    public String getCurrentPath() {
        return this.fullPath;
    }

    @Override
    public ConfigurationSection getDefaultSection() {
        Configuration defaults;
        Configuration root = this.getRoot();
        Configuration configuration = defaults = root == null ? null : root.getDefaults();
        if (defaults != null && defaults.isConfigurationSection(this.getCurrentPath())) {
            return defaults.getConfigurationSection(this.getCurrentPath());
        }
        return null;
    }

    @Override
    public double getDouble(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getDouble(path, def instanceof Number ? NumberConversions.toDouble(def) : 0.0);
    }

    @Override
    public double getDouble(@NotNull String path, double def) {
        Object val = this.get(path, def);
        return val instanceof Number ? NumberConversions.toDouble(val) : def;
    }

    @Override
    @NotNull
    public List<Double> getDoubleList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Double>(0);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        list.forEach(object -> {
            if (object instanceof Double) {
                result.add((Double)object);
            } else if (object instanceof String) {
                try {
                    result.add(Double.valueOf((String)object));
                }
                catch (Exception exception) {}
            } else if (object instanceof Character) {
                result.add(Double.valueOf(((Character)object).charValue()));
            } else if (object instanceof Number) {
                result.add(((Number)object).doubleValue());
            }
        });
        return result;
    }

    @Override
    @NotNull
    public List<Float> getFloatList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Float>(0);
        }
        ArrayList<Float> result = new ArrayList<Float>();
        list.forEach(object -> {
            if (object instanceof Float) {
                result.add((Float)object);
            } else if (object instanceof String) {
                try {
                    result.add(Float.valueOf((String)object));
                }
                catch (Exception exception) {}
            } else if (object instanceof Character) {
                result.add(Float.valueOf(((Character)object).charValue()));
            } else if (object instanceof Number) {
                result.add(Float.valueOf(((Number)object).floatValue()));
            }
        });
        return result;
    }

    @Override
    public int getInt(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getInt(path, def instanceof Number ? NumberConversions.toInt(def) : 0);
    }

    @Override
    public int getInt(@NotNull String path, int def) {
        Object val = this.get(path, def);
        return val instanceof Number ? NumberConversions.toInt(val) : def;
    }

    @Override
    @NotNull
    public List<Integer> getIntegerList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        list.forEach(object -> {
            if (object instanceof Integer) {
                result.add((Integer)object);
            } else if (object instanceof String) {
                try {
                    result.add(Integer.valueOf((String)object));
                }
                catch (Exception exception) {}
            } else if (object instanceof Character) {
                result.add(Integer.valueOf(((Character)object).charValue()));
            } else if (object instanceof Number) {
                result.add(((Number)object).intValue());
            }
        });
        return result;
    }

    @Override
    @NotNull
    public Set<String> getKeys(boolean deep) {
        ConfigurationSection defaults;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Configuration root = this.getRoot();
        if (root != null && root.options().copyDefaults() && (defaults = this.getDefaultSection()) != null) {
            result.addAll(defaults.getKeys(deep));
        }
        this.mapChildrenKeys(result, this, deep);
        return result;
    }

    @Override
    public List<?> getList(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getList(path, def instanceof List ? (List)def : null);
    }

    @Override
    public List<?> getList(@NotNull String path, List<?> def) {
        List<?> val = this.get(path, def);
        return val instanceof List ? val : def;
    }

    @Override
    public long getLong(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getLong(path, def instanceof Number ? NumberConversions.toLong(def) : 0L);
    }

    @Override
    public long getLong(@NotNull String path, long def) {
        Object val = this.get(path, def);
        return val instanceof Number ? NumberConversions.toLong(val) : def;
    }

    @Override
    @NotNull
    public List<Long> getLongList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> result = new ArrayList<Long>();
        list.forEach(object -> {
            if (object instanceof Long) {
                result.add((Long)object);
            } else if (object instanceof String) {
                try {
                    result.add(Long.valueOf((String)object));
                }
                catch (Exception exception) {}
            } else if (object instanceof Character) {
                result.add(Long.valueOf(((Character)object).charValue()));
            } else if (object instanceof Number) {
                result.add(((Number)object).longValue());
            }
        });
        return result;
    }

    @Override
    @NotNull
    public List<Map<?, ?>> getMapList(@NotNull String path) {
        List<?> list = this.getList(path);
        ArrayList result = new ArrayList();
        if (list == null) {
            return result;
        }
        list.stream().filter(Map.class::isInstance).map(object -> (Map)object).forEach(result::add);
        return result;
    }

    @Override
    @NotNull
    public String getName() {
        return this.path;
    }

    @Override
    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz) {
        Object def = this.getDefault(path);
        return this.getObject(path, clazz, clazz.isInstance(def) ? (T)clazz.cast(def) : null);
    }

    @Override
    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz, @Nullable T def) {
        Object val = this.get(path, def);
        return clazz.isInstance(val) ? clazz.cast(val) : def;
    }

    @Override
    public ConfigurationSection getParent() {
        return this.parent;
    }

    @Override
    public Configuration getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public List<Short> getShortList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Short>(0);
        }
        ArrayList<Short> result = new ArrayList<Short>();
        list.forEach(object -> {
            if (object instanceof Short) {
                result.add((Short)object);
            } else if (object instanceof String) {
                try {
                    result.add(Short.valueOf((String)object));
                }
                catch (Exception exception) {}
            } else if (object instanceof Character) {
                result.add((short)((Character)object).charValue());
            } else if (object instanceof Number) {
                result.add(((Number)object).shortValue());
            }
        });
        return result;
    }

    @Override
    public String getString(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getString(path, def != null ? def.toString() : null);
    }

    @Override
    public String getString(@NotNull String path, String def) {
        Object val = this.get(path, def);
        return val != null ? val.toString() : def;
    }

    @Override
    @NotNull
    public List<String> getStringList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<String>(0);
        }
        return list.stream().filter(object -> object instanceof String || this.isPrimitiveWrapper(object)).map(String::valueOf).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Map<String, Object> getValues(boolean deep) {
        ConfigurationSection defaults;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Configuration root = this.getRoot();
        if (root != null && root.options().copyDefaults() && (defaults = this.getDefaultSection()) != null) {
            result.putAll(defaults.getValues(deep));
        }
        this.mapChildrenValues(result, this, deep);
        return result;
    }

    @Override
    public boolean isBoolean(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof Boolean;
    }

    @Override
    public boolean isConfigurationSection(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof ConfigurationSection;
    }

    @Override
    public boolean isDouble(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof Double;
    }

    @Override
    public boolean isInt(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof Integer;
    }

    @Override
    public boolean isList(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof List;
    }

    @Override
    public boolean isLong(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof Long;
    }

    @Override
    public boolean isSet(@NotNull String path) {
        Configuration root = this.getRoot();
        if (root == null) {
            return false;
        }
        if (root.options().copyDefaults()) {
            return this.contains(path);
        }
        return this.get(path, null) != null;
    }

    @Override
    public boolean isString(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof String;
    }

    @Override
    public void set(@NotNull String path, Object value) {
        int i2;
        Validate.checkEmpty(path, "Cannot set to an empty path");
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot use section without a root");
        }
        char separator = root.options().pathSeparator();
        int i1 = -1;
        ConfigurationSection section = this;
        while ((i1 = path.indexOf(separator, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            ConfigurationSection subSection = section.getConfigurationSection(node);
            if (subSection == null) {
                section = section.createSection(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        if (section == this) {
            if (value == null) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        } else {
            section.set(key, value);
        }
    }

    public String toString() {
        Configuration root = this.getRoot();
        return this.getClass().getSimpleName() + "[path='" + this.getCurrentPath() + "', root='" + (root == null ? null : root.getClass().getSimpleName()) + "']";
    }

    @Nullable
    protected Object getDefault(@NotNull String path) {
        Configuration root = this.getRoot();
        Configuration defaults = root == null ? null : root.getDefaults();
        return defaults == null ? null : defaults.get(MemorySection.createPath(this, path));
    }

    protected boolean isPrimitiveWrapper(Object input) {
        return input instanceof Integer || input instanceof Boolean || input instanceof Character || input instanceof Byte || input instanceof Short || input instanceof Double || input instanceof Long || input instanceof Float;
    }

    protected void mapChildrenKeys(Set<String> output, ConfigurationSection section, boolean deep) {
        if (section instanceof MemorySection) {
            MemorySection sec = (MemorySection)section;
            sec.map.forEach((key, value) -> {
                output.add(MemorySection.createPath(section, key, this));
                if (deep && value instanceof ConfigurationSection) {
                    ConfigurationSection subsection = (ConfigurationSection)value;
                    this.mapChildrenKeys(output, subsection, true);
                }
            });
        } else {
            Set<String> keys = section.getKeys(deep);
            keys.stream().map(key -> MemorySection.createPath(section, key, this)).forEach(output::add);
        }
    }

    protected void mapChildrenValues(Map<String, Object> output, ConfigurationSection section, boolean deep) {
        if (section instanceof MemorySection) {
            MemorySection sec = (MemorySection)section;
            sec.map.forEach((key, value) -> {
                output.put(MemorySection.createPath(section, key, this), value);
                if (value instanceof ConfigurationSection && deep) {
                    this.mapChildrenValues(output, (ConfigurationSection)value, deep);
                }
            });
        } else {
            Map<String, Object> values = section.getValues(deep);
            values.forEach((key, value) -> output.put(MemorySection.createPath(section, key, this), value));
        }
    }
}

