/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.springframework.boot.env.PropertySourcesLoader;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.AntPathMatcher;
import top.wboost.common.base.enums.CharsetEnum;
import top.wboost.common.exception.BusinessException;
import top.wboost.common.log.entity.Logger;
import top.wboost.common.log.util.LoggerUtil;
import top.wboost.common.util.StringUtil;
import top.wboost.common.utils.web.core.ConfigProperties;

public class PropertiesUtil {
    private static Logger log = LoggerUtil.getLogger(PropertiesUtil.class);
    private static PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private static AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static PropertySourcesLoader propertySourcesLoader = new PropertySourcesLoader();
    private static ResourceLoader resourceLoader = new DefaultResourceLoader();

    public static String getProperty(String name) {
        return PropertiesUtil.getPropertyOrDefault(name, null, null);
    }

    public static String getProperty(String name, String path) {
        return PropertiesUtil.getPropertyOrDefault(name, path, null);
    }

    public static String getPropertyOrDefault(String name, String defaultVal) {
        return PropertiesUtil.getPropertyOrDefault(name, null, defaultVal);
    }

    public static String getPropertyOrDefault(String name, String path, String defaultVal) {
        String val;
        block9: {
            val = null;
            try {
                if (!StringUtil.notEmpty((Object)path).booleanValue()) {
                    if (ConfigProperties.resolver != null) {
                        val = ConfigProperties.resolver.resolveStringValue("${" + name + "}");
                    }
                    if (("${" + name + "}").equals(val)) {
                        val = null;
                    }
                    break block9;
                }
                try {
                    EncodedResource[] resources;
                    for (EncodedResource resource : resources = PropertiesUtil.loadResources(path)) {
                        Properties properties = PropertiesLoaderUtils.loadProperties((EncodedResource)resource);
                        Object obj = properties.get(name);
                        if (obj == null) continue;
                        val = obj.toString();
                        break;
                    }
                }
                catch (IOException e) {
                    if (log.isWarnEnabled()) {
                        log.warn(e.getLocalizedMessage());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val == null ? defaultVal : val;
    }

    public static Map<String, Object> getPropertiesByPattern(String pattern) {
        Pattern patternDo = Pattern.compile(pattern);
        LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>();
        PropertiesUtil.getAllProperties().forEach((key, val) -> {
            if (patternDo.matcher((CharSequence)key).find()) {
                filterMap.put((String)key, val);
            }
        });
        return filterMap;
    }

    public static Properties loadProperties(String location) {
        EncodedResource[] resources = PropertiesUtil.loadResources(location);
        Properties prop = new Properties();
        try {
            for (EncodedResource resource : resources) {
                prop.putAll((Map<?, ?>)PropertiesLoaderUtils.loadProperties((EncodedResource)resource));
            }
            return prop;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Properties();
        }
    }

    public static Map<String, Object> getPropertiesByPrefix(String prefix) {
        return PropertiesUtil.getPropertiesByPrefix(prefix, PropertiesUtil.getAllProperties());
    }

    public static Map<String, Object> getAllProperties() {
        NoConverterMap<String, Object> retMap = new NoConverterMap<String, Object>();
        if (ConfigProperties.environment instanceof StandardEnvironment) {
            StandardEnvironment standardEnvironment = (StandardEnvironment)ConfigProperties.environment;
            for (PropertySource s : standardEnvironment.getPropertySources()) {
                retMap.putAll(PropertiesUtil.resolvePropertySource(s));
            }
        }
        return retMap;
    }

    public static Map<String, Object> resolvePropertySource(PropertySource<?> propertySource) {
        NoConverterMap<String, Object> resolveMap = new NoConverterMap<String, Object>();
        if (propertySource.getSource() instanceof Map) {
            resolveMap.putAll((Map)propertySource.getSource());
        } else if (propertySource instanceof EnumerablePropertySource) {
            EnumerablePropertySource source = (EnumerablePropertySource)propertySource;
            String[] nameArray = source.getPropertyNames();
            Arrays.asList(nameArray).forEach(name -> resolveMap.put((String)name, propertySource.getProperty(name)));
        }
        return resolveMap;
    }

    private static EncodedResource[] loadResources(String location) {
        try {
            Resource[] resources = resourceResolver.getResources(location);
            EncodedResource[] encodeResources = new EncodedResource[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                encodeResources[i] = new EncodedResource(resource, CharsetEnum.UTF_8.getCharset());
            }
            return encodeResources;
        }
        catch (Exception e) {
            log.error("loadResource error", (Throwable)e);
            throw new BusinessException("loadResource error");
        }
    }

    public static PropertySource<?> loadPropertySource(String location) {
        try {
            Resource bootstrapResource = resourceLoader.getResource(location);
            return propertySourcesLoader.load(bootstrapResource, "applicationConfig: [profile=]", "wboostConfigLoader: [" + location + "]", null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getPropertiesByPrefix(String prefix, PropertySource<?> propertySource) {
        return PropertiesUtil.getPropertiesByPrefix(prefix, PropertiesUtil.resolvePropertySource(propertySource));
    }

    public static Map<String, Object> getPropertiesByPrefix(String prefix, Map<String, Object> propMap) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : propMap.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            retMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }

    public static Object getPropertiesObject(String name) {
        return PropertiesUtil.getAllProperties().get(name);
    }

    public static Map<String, Object> resolveProperties(Map<String, Object> props) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        props.forEach((key, val) -> {
            if (val instanceof String) {
                retMap.put((String)key, PropertiesUtil.getProperty(key));
            } else {
                retMap.put((String)key, val);
            }
        });
        return retMap;
    }

    public static class NoConverterMap<K, V>
    extends HashMap<K, V> {
        @Override
        public V put(K key, V value) {
            if (!this.containsKey(key)) {
                return super.put(key, value);
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            m.entrySet().forEach((? super T entry) -> this.put(entry.getKey(), entry.getValue()));
        }
    }
}

