/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class VerifyCodeUtil {
    private static int w = 100;
    private static int h = 45;
    private static Random r = new Random();
    private static String[] fontNames = new String[]{"\u5b8b\u4f53", "\u534e\u6587\u6977\u4f53", "\u9ed1\u4f53", "\u5fae\u8f6f\u96c5\u9ed1", "\u6977\u4f53_GB2312"};
    private static String codes = "23456789QWERTYUPKJHGFDSAZXCVBNM";
    private static Color bgcolor = new Color(255, 255, 255);

    private static Color randomColor() {
        int red = r.nextInt(150);
        int green = r.nextInt(150);
        int blue = r.nextInt(150);
        return new Color(red, green, blue);
    }

    private static Font randomFont() {
        int index = r.nextInt(fontNames.length);
        String fontName = fontNames[index];
        int style = r.nextInt(4);
        int size = r.nextInt(5) + 24;
        return new Font(fontName, style, size);
    }

    private static void drawLine(BufferedImage image) {
        int num = 5;
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        for (int i = 0; i < num; ++i) {
            int x1 = r.nextInt(w);
            int y1 = r.nextInt(h);
            int x2 = r.nextInt(w);
            int y2 = r.nextInt(h);
            g2.setStroke(new BasicStroke(1.5f));
            g2.setColor(Color.BLUE);
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    private static char randomChar() {
        int index = r.nextInt(codes.length());
        return codes.charAt(index);
    }

    private static BufferedImage createImage() {
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(bgcolor);
        g2.fillRect(0, 0, w, h);
        return image;
    }

    private static Map<String, Object> getImage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BufferedImage image = VerifyCodeUtil.createImage();
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            String s = VerifyCodeUtil.randomChar() + "";
            sb.append(s);
            float x = (float)i * 1.0f * (float)w / 4.0f;
            g2.setFont(VerifyCodeUtil.randomFont());
            g2.setColor(VerifyCodeUtil.randomColor());
            g2.drawString(s, x, (float)(h - 5));
        }
        VerifyCodeUtil.drawLine(image);
        map.put("bufferedImage", image);
        map.put("text", sb.toString());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputImg(HttpSession session, HttpServletResponse response) throws Exception {
        try (ServletOutputStream servletOutputStream = null;){
            Map<String, Object> imageMap = VerifyCodeUtil.getImage();
            session.setAttribute("verifyCode", (Object)imageMap.get("text").toString());
            servletOutputStream = response.getOutputStream();
            ImageIO.write((RenderedImage)((BufferedImage)imageMap.get("bufferedImage")), "JPEG", (OutputStream)servletOutputStream);
        }
    }
}

