/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    public static final String CRON_FORMAT = "ss mm HH dd MM ? yyyy";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<Map<String, DateFormat>> DATE_FORMAT_THREAD_LOCAL = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getDateFormat(String pattern) {
        if (pattern == null || pattern.trim().isEmpty()) {
            throw new IllegalArgumentException("pattern cannot be empty.");
        }
        Map<String, DateFormat> dateFormatMap = DATE_FORMAT_THREAD_LOCAL.get();
        if (dateFormatMap != null && dateFormatMap.containsKey(pattern)) {
            return dateFormatMap.get(pattern);
        }
        ThreadLocal<Map<String, DateFormat>> threadLocal = DATE_FORMAT_THREAD_LOCAL;
        synchronized (threadLocal) {
            if (dateFormatMap == null) {
                dateFormatMap = new HashMap<String, DateFormat>();
            }
            dateFormatMap.put(pattern, new SimpleDateFormat(pattern));
            DATE_FORMAT_THREAD_LOCAL.set(dateFormatMap);
        }
        return dateFormatMap.get(pattern);
    }

    public static String getCron(Date date) {
        return DateUtil.format(date, CRON_FORMAT);
    }

    public static String getCron(String date) {
        return DateUtil.format(DateUtil.parseDateTime(date), CRON_FORMAT);
    }

    public static String getCron(LocalDateTime date) {
        return DateUtil.format(date, CRON_FORMAT);
    }

    public static String format(LocalDateTime date, String pattern) {
        if (date == null) {
            date = LocalDateTime.now();
        }
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatDate(Date date) {
        return DateUtil.format(date, DATE_FORMAT);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.format(date, DATETIME_FORMAT);
    }

    public static String format(Date date, String patten) {
        return DateUtil.getDateFormat(patten).format(date);
    }

    public static Date parseDate(String dateString) {
        return DateUtil.parse(dateString, DATE_FORMAT);
    }

    public static Date parseDateTime(String dateString) {
        return DateUtil.parse(dateString, DATETIME_FORMAT);
    }

    public static Date parse(String dateString, String pattern) {
        try {
            return DateUtil.getDateFormat(pattern).parse(dateString);
        }
        catch (Exception e) {
            logger.warn("parse date error, dateString = {}, pattern={}; errorMsg = {}", new Object[]{dateString, pattern, e.getMessage()});
            return null;
        }
    }

    public static Date addYears(Date date, int amount) {
        return DateUtil.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtil.add(date, 2, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtil.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtil.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtil.add(date, 12, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }
}

