/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.handler.impl;

import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.util.ScriptUtil;
import java.io.File;
import lombok.Generated;

public class ScriptJobHandler
extends IJobHandler {
    private final int jobId;
    private final long glueUpdateTime;
    private final String glueSource;
    private final GlueTypeEnum glueType;

    public ScriptJobHandler(int jobId, long glueUpdateTime, String glueSource, GlueTypeEnum glueType) {
        File[] glueSrcFileList;
        this.jobId = jobId;
        this.glueUpdateTime = glueUpdateTime;
        this.glueSource = glueSource;
        this.glueType = glueType;
        File glueSrcPath = new File(XxlJobFileAppender.getGlueSrcPath());
        if (glueSrcPath.exists() && (glueSrcFileList = glueSrcPath.listFiles()) != null && glueSrcFileList.length > 0) {
            for (File glueSrcFileItem : glueSrcFileList) {
                if (!glueSrcFileItem.getName().startsWith(String.valueOf(jobId) + "_")) continue;
                glueSrcFileItem.delete();
            }
        }
    }

    @Override
    public void execute() throws Exception {
        if (!this.glueType.isScript()) {
            XxlJobHelper.handleFail("glueType[" + this.glueType + "] invalid.");
            return;
        }
        String cmd = this.glueType.getCmd();
        String scriptFileName = XxlJobFileAppender.getGlueSrcPath().concat(File.separator).concat(String.valueOf(this.jobId)).concat("_").concat(String.valueOf(this.glueUpdateTime)).concat(this.glueType.getSuffix());
        File scriptFile = new File(scriptFileName);
        if (!scriptFile.exists()) {
            ScriptUtil.markScriptFile(scriptFileName, this.glueSource);
        }
        String logFileName = XxlJobContext.getXxlJobContext().getJobLogFileName();
        String[] scriptParams = new String[]{XxlJobHelper.getJobParam(), String.valueOf(XxlJobContext.getXxlJobContext().getShardIndex()), String.valueOf(XxlJobContext.getXxlJobContext().getShardTotal())};
        XxlJobHelper.log("----------- script file:" + scriptFileName + " -----------", new Object[0]);
        int exitValue = ScriptUtil.execToFile(cmd, scriptFileName, logFileName, scriptParams);
        if (exitValue == 0) {
            XxlJobHelper.handleSuccess();
        } else {
            XxlJobHelper.handleFail("script exit value(" + exitValue + ") is failed");
        }
    }

    @Generated
    public long getGlueUpdateTime() {
        return this.glueUpdateTime;
    }
}

