/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.xss.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssUtils.class);
    private static final String ANTISAMY_SLASHDOT_XML = "antisamy-slashdot-1.4.4.xml";
    private static final Pattern SCRIPT_BETWEEN_PATTERN = Pattern.compile("<[\r\n| | ]*script[\r\n| | ]*>(.*?)</[\r\n| | ]*script[\r\n| | ]*>", 2);
    private static final Pattern SCRIPT_END_PATTERN = Pattern.compile("</[\r\n| | ]*script[\r\n| | ]*>", 2);
    private static final Pattern SCRIPT_START_PATTERN = Pattern.compile("<[\r\n| | ]*script(.*?)>", 42);
    private static final Pattern EVAL_PATTERN = Pattern.compile("eval\\((.*?)\\)", 42);
    private static final Pattern E_XPRESSION_PATTERN = Pattern.compile("e-xpression\\((.*?)\\)", 42);
    private static final Pattern MOCHA_PATTERN = Pattern.compile("mocha[\r\n| | ]*:[\r\n| | ]*", 42);
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("expression\\((.*?)\\)", 42);
    private static final Pattern URL_PATTERN = Pattern.compile("url\\((.*?)\\)", 42);
    private static final Pattern VBSCRIPT_PATTERN = Pattern.compile("vbscript[\r\n| | ]*:[\r\n| | ]*", 42);
    private static final Pattern JAVASCRIPT_PATTERN = Pattern.compile("javascript[\r\n| | ]*:[\r\n| | ]*", 2);
    private static final Pattern ONLOAD_PATTERN = Pattern.compile("onload(.*?)=", 42);
    private static final Pattern ONMOUSEOVER_PATTERN = Pattern.compile("onMouseOver=.*?//", 42);
    private static final Pattern ONMOUSEOVER_PATTERN_2 = Pattern.compile("onmouseover(.*)", 42);
    private static final Pattern ONMOUSEOVER_PATTERN_3 = Pattern.compile("onmouseover=.*?", 42);
    private static final Pattern ALERT_PATTERN = Pattern.compile("alert(.*)", 42);
    private static Policy policy = null;
    private static final String REPLACE_STRING = "";

    public static String xssClean(String paramValue, List<String> ignoreParamValueList) {
        AntiSamy antiSamy = new AntiSamy();
        try {
            log.debug("raw value before xssClean: {}", (Object)paramValue);
            if (XssUtils.isIgnoreParamValue(paramValue, ignoreParamValueList)) {
                log.debug("ignore the xssClean,keep the raw paramValue: {}", (Object)paramValue);
                return paramValue;
            }
            CleanResults cr = antiSamy.scan(paramValue, policy);
            cr.getErrorMessages().forEach(arg_0 -> ((Logger)log).debug(arg_0));
            String str = cr.getCleanHTML();
            str = XssUtils.stripXssAndSql(str);
            str = str.replaceAll("&quot;", "\"");
            str = str.replaceAll("&amp;", "&");
            str = str.replaceAll("&lt;", "<");
            str = str.replaceAll("&gt;", ">");
            log.debug("xss filter value after xssClean" + str);
            return str;
        }
        catch (ScanException e) {
            log.error("scan failed is [{}]", (Object)paramValue, (Object)e);
        }
        catch (PolicyException e) {
            log.error("antisamy convert failed  is [{}]", (Object)paramValue, (Object)e);
        }
        return paramValue;
    }

    public static String xssClean(String paramValue, List<String> ignoreParamValueList, String param) {
        if (XssUtils.isIgnoreParamValue(param, ignoreParamValueList)) {
            return XssUtils.stripXssAndSql(paramValue);
        }
        return XssUtils.xssClean(paramValue, ignoreParamValueList);
    }

    public static String stripXssAndSql(String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return value;
        }
        value = SCRIPT_BETWEEN_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = SCRIPT_END_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = SCRIPT_START_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = EVAL_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = E_XPRESSION_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = MOCHA_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = EXPRESSION_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = URL_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = VBSCRIPT_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = JAVASCRIPT_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = ONLOAD_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = ONMOUSEOVER_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        value = ONMOUSEOVER_PATTERN_2.matcher(value).replaceAll(REPLACE_STRING);
        value = ONMOUSEOVER_PATTERN_3.matcher(value).replaceAll(REPLACE_STRING);
        value = ALERT_PATTERN.matcher(value).replaceAll(REPLACE_STRING);
        return value;
    }

    private static boolean isIgnoreParamValue(String paramValue, List<String> ignoreParamValueList) {
        if (StrUtil.isBlank((CharSequence)paramValue)) {
            return true;
        }
        if (CollectionUtil.isEmpty(ignoreParamValueList)) {
            return false;
        }
        for (String ignoreParamValue : ignoreParamValueList) {
            if (!paramValue.contains(ignoreParamValue)) continue;
            return true;
        }
        return false;
    }

    static {
        log.debug(" start read XSS config file [antisamy-slashdot-1.4.4.xml]");
        try (InputStream inputStream = XssUtils.class.getClassLoader().getResourceAsStream(ANTISAMY_SLASHDOT_XML);){
            if (inputStream != null) {
                policy = Policy.getInstance((InputStream)inputStream);
            }
            log.debug("read XSS config file [antisamy-slashdot-1.4.4.xml] success");
        }
        catch (IOException | PolicyException e) {
            log.error("read XSS config file [antisamy-slashdot-1.4.4.xml] fail , reason:", e);
        }
    }
}

