/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.xss.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import top.tangyh.basic.xss.wrapper.XssRequestWrapper;

public class XssFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssFilter.class);
    public static final String IGNORE_PATH = "ignorePath";
    public static final String IGNORE_PARAM_VALUE = "ignoreParamValue";
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private List<String> ignorePathList;
    private List<String> ignoreParamValueList;

    public void init(FilterConfig fc) {
        this.ignorePathList = StrUtil.split((CharSequence)fc.getInitParameter(IGNORE_PATH), (char)',');
        this.ignoreParamValueList = StrUtil.split((CharSequence)fc.getInitParameter(IGNORE_PARAM_VALUE), (char)',');
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uriPath = ((HttpServletRequest)request).getRequestURI();
        if (this.isIgnorePath(uriPath)) {
            log.debug("\u5ffd\u7565\u8fc7\u6ee4\u8def\u5f84=[{}]", (Object)uriPath);
            chain.doFilter(request, response);
            return;
        }
        log.debug("\u8fc7\u6ee4\u5668\u5305\u88c5\u8bf7\u6c42\u8def\u5f84=[{}]", (Object)uriPath);
        chain.doFilter((ServletRequest)new XssRequestWrapper((HttpServletRequest)request, this.ignoreParamValueList), response);
    }

    private boolean isIgnorePath(String uriPath) {
        if (StrUtil.isBlank((CharSequence)uriPath)) {
            return true;
        }
        if (CollUtil.isEmpty(this.ignorePathList)) {
            return false;
        }
        return this.ignorePathList.stream().anyMatch(url -> uriPath.startsWith((String)url) || ANT_PATH_MATCHER.match(url, uriPath));
    }
}

