/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.xss;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.HashMap;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import top.tangyh.basic.xss.converter.XssStringJsonDeserializer;
import top.tangyh.basic.xss.filter.XssFilter;
import top.tangyh.basic.xss.properties.XssProperties;

@EnableConfigurationProperties(value={XssProperties.class})
public class XssAuthConfiguration {
    private final XssProperties xssProperties;

    @Bean
    @ConditionalOnProperty(prefix="lamp.xss", name={"requestBodyEnabled"}, havingValue="true")
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer2() {
        return builder -> builder.deserializerByType(String.class, (JsonDeserializer)new XssStringJsonDeserializer());
    }

    @Bean
    @ConditionalOnProperty(prefix="lamp.xss", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new XssFilter());
        filterRegistration.setEnabled(this.xssProperties.getEnabled().booleanValue());
        filterRegistration.addUrlPatterns(this.xssProperties.getPatterns().toArray(new String[0]));
        filterRegistration.setOrder(this.xssProperties.getOrder());
        HashMap<String, String> initParameters = new HashMap<String, String>(4);
        initParameters.put("ignorePath", CollUtil.join(this.xssProperties.getIgnorePaths(), (CharSequence)","));
        initParameters.put("ignoreParamValue", CollUtil.join(this.xssProperties.getIgnoreParamValues(), (CharSequence)","));
        filterRegistration.setInitParameters(initParameters);
        return filterRegistration;
    }

    public XssAuthConfiguration(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

