/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.validator.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.idev.excel.annotation.ExcelProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.context.ConstraintDefinitionContext;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.internal.cfg.context.DefaultConstraintMapping;
import org.hibernate.validator.internal.engine.DefaultPropertyNodeNameProvider;
import org.hibernate.validator.internal.properties.DefaultGetterPropertySelectionStrategy;
import org.hibernate.validator.internal.properties.javabean.JavaBeanHelper;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.annotation.constraints.NotEmptyPattern;
import top.tangyh.basic.exception.BizException;
import top.tangyh.basic.validator.constraintvalidators.LengthConstraintValidator;
import top.tangyh.basic.validator.constraintvalidators.NotEmptyConstraintValidator;
import top.tangyh.basic.validator.constraintvalidators.NotEmptyPatternConstraintValidator;
import top.tangyh.basic.validator.constraintvalidators.NotNullConstraintValidator;

public class ValidatorUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatorUtils.class);
    private static final Validator VALIDATOR_FAST = ValidatorUtils.warp((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory().getValidator();
    private static final Validator VALIDATOR_ALL = ValidatorUtils.warp((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory().getValidator();

    public static <T> Set<ConstraintViolation<T>> validateFastSneaky(T domain) {
        Set validateResult = VALIDATOR_FAST.validate(domain, new Class[0]);
        if (!validateResult.isEmpty()) {
            log.warn("{}:{}", (Object)((ConstraintViolation)validateResult.iterator().next()).getPropertyPath(), (Object)((ConstraintViolation)validateResult.iterator().next()).getMessage());
        }
        return validateResult;
    }

    public static <T> void validateFast(T domain) {
        Set validateResult = VALIDATOR_FAST.validate(domain, new Class[0]);
        if (!validateResult.isEmpty()) {
            log.warn("{}:{}", (Object)((ConstraintViolation)validateResult.iterator().next()).getPropertyPath(), (Object)((ConstraintViolation)validateResult.iterator().next()).getMessage());
            throw BizException.wrap((String)"{}:{}", (Object[])new Object[]{((ConstraintViolation)validateResult.iterator().next()).getPropertyPath(), ((ConstraintViolation)validateResult.iterator().next()).getMessage()});
        }
    }

    public static <T> Set<ConstraintViolation<T>> validateAllSneaky(T domain) {
        Set validateResult = VALIDATOR_ALL.validate(domain, new Class[0]);
        if (!validateResult.isEmpty()) {
            for (ConstraintViolation cv : validateResult) {
                Schema apiModelProperty;
                Field field = ReflectUtil.getField((Class)cv.getRootBeanClass(), (String)cv.getPropertyPath().toString());
                ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
                String name = "";
                name = excelProperty == null ? ((apiModelProperty = field.getAnnotation(Schema.class)) != null ? apiModelProperty.description() : "") : StrUtil.join((CharSequence)".", (Object[])excelProperty.value());
                log.warn("{}:{} :{}", new Object[]{name, cv.getPropertyPath(), cv.getMessage()});
            }
        }
        return validateResult;
    }

    public static <T> String validateAllSneaky(List<T> domains, int headRow) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < domains.size(); ++i) {
            T domain = domains.get(i);
            Set validateResult = VALIDATOR_ALL.validate(domain, new Class[0]);
            if (validateResult.isEmpty()) continue;
            for (ConstraintViolation cv : validateResult) {
                Field field = ReflectUtil.getField((Class)cv.getRootBeanClass(), (String)cv.getPropertyPath().toString());
                ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
                String name = "";
                if (excelProperty != null) {
                    name = StrUtil.join((CharSequence)".", (Object[])excelProperty.value());
                }
                if (StrUtil.isEmpty((CharSequence)name)) {
                    Schema apiModelProperty = field.getAnnotation(Schema.class);
                    String string = name = apiModelProperty != null ? apiModelProperty.description() : "";
                }
                if (StrUtil.isEmpty((CharSequence)name)) {
                    name = field.getName();
                }
                Object value = BeanUtil.getFieldValue(domain, (String)field.getName());
                sb.append(StrUtil.format((CharSequence)"\u7b2c{}\u884c\uff0c{} = {} : {}<br/>", (Object[])new Object[]{headRow + i + 1, name, value, cv.getMessage()}));
            }
        }
        return sb.toString();
    }

    public static Configuration<HibernateValidatorConfiguration> warp(HibernateValidatorConfiguration configuration) {
        ValidatorUtils.addValidatorMapping(configuration);
        return configuration;
    }

    private static void addValidatorMapping(HibernateValidatorConfiguration configuration) {
        DefaultGetterPropertySelectionStrategy getterPropertySelectionStrategyToUse = new DefaultGetterPropertySelectionStrategy();
        DefaultPropertyNodeNameProvider defaultPropertyNodeNameProvider = new DefaultPropertyNodeNameProvider();
        DefaultConstraintMapping mapping = new DefaultConstraintMapping(new JavaBeanHelper((GetterPropertySelectionStrategy)getterPropertySelectionStrategyToUse, (PropertyNodeNameProvider)defaultPropertyNodeNameProvider));
        ConstraintDefinitionContext length = mapping.constraintDefinition(Length.class);
        length.includeExistingValidators(true);
        length.validatedBy(LengthConstraintValidator.class);
        ConstraintDefinitionContext notNull = mapping.constraintDefinition(NotNull.class);
        notNull.includeExistingValidators(true);
        notNull.validatedBy(NotNullConstraintValidator.class);
        ConstraintDefinitionContext notEmpty = mapping.constraintDefinition(NotEmpty.class);
        notEmpty.includeExistingValidators(true);
        notEmpty.validatedBy(NotEmptyConstraintValidator.class);
        ConstraintDefinitionContext notEmptyPattern = mapping.constraintDefinition(NotEmptyPattern.class);
        notEmptyPattern.includeExistingValidators(true);
        notEmptyPattern.validatedBy(NotEmptyPatternConstraintValidator.class);
        configuration.addMapping((ConstraintMapping)mapping);
    }
}

