/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.fsg.uid.impl;

import com.baidu.fsg.uid.buffer.BufferPaddingExecutor;
import com.baidu.fsg.uid.buffer.RejectedPutBufferHandler;
import com.baidu.fsg.uid.buffer.RejectedTakeBufferHandler;
import com.baidu.fsg.uid.buffer.RingBuffer;
import com.baidu.fsg.uid.exception.UidGenerateException;
import com.baidu.fsg.uid.impl.DefaultUidGenerator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

public class CachedUidGenerator
extends DefaultUidGenerator
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedUidGenerator.class);
    private static final int DEFAULT_BOOST_POWER = 3;
    private int boostPower = 3;
    private int paddingFactor = 50;
    private Long scheduleInterval;
    private RejectedPutBufferHandler rejectedPutBufferHandler;
    private RejectedTakeBufferHandler rejectedTakeBufferHandler;
    private RingBuffer ringBuffer;
    private BufferPaddingExecutor bufferPaddingExecutor;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.initRingBuffer();
        LOGGER.info("Initialized RingBuffer successfully.");
    }

    @Override
    public long getUid() {
        try {
            return this.ringBuffer.take();
        }
        catch (Exception e) {
            LOGGER.error("Generate unique id exception. ", (Throwable)e);
            throw new UidGenerateException(e);
        }
    }

    public void destroy() {
        this.bufferPaddingExecutor.shutdown();
    }

    protected List<Long> nextIdsForOneSecond(long currentSecond) {
        int listSize = (int)this.bitsAllocator.getMaxSequence() + 1;
        ArrayList<Long> uidList = new ArrayList<Long>(listSize);
        long firstSeqUid = this.bitsAllocator.allocate(currentSecond - this.epochSeconds, this.workerId, 0L);
        for (int offset = 0; offset < listSize; ++offset) {
            uidList.add(firstSeqUid + (long)offset);
        }
        return uidList;
    }

    private void initRingBuffer() {
        int bufferSize = (int)this.bitsAllocator.getMaxSequence() + 1 << this.boostPower;
        this.ringBuffer = new RingBuffer(bufferSize, this.paddingFactor);
        LOGGER.info("Initialized ring buffer size:{}, paddingFactor:{}", (Object)bufferSize, (Object)this.paddingFactor);
        boolean usingSchedule = this.scheduleInterval != null;
        this.bufferPaddingExecutor = new BufferPaddingExecutor(this.ringBuffer, this::nextIdsForOneSecond, usingSchedule);
        if (usingSchedule) {
            this.bufferPaddingExecutor.setScheduleInterval(this.scheduleInterval);
        }
        LOGGER.info("Initialized BufferPaddingExecutor. Using schdule:{}, interval:{}", (Object)usingSchedule, (Object)this.scheduleInterval);
        this.ringBuffer.setBufferPaddingExecutor(this.bufferPaddingExecutor);
        if (this.rejectedPutBufferHandler != null) {
            this.ringBuffer.setRejectedPutHandler(this.rejectedPutBufferHandler);
        }
        if (this.rejectedTakeBufferHandler != null) {
            this.ringBuffer.setRejectedTakeHandler(this.rejectedTakeBufferHandler);
        }
        this.bufferPaddingExecutor.paddingBuffer();
        this.bufferPaddingExecutor.start();
    }

    public void setBoostPower(int boostPower) {
        Assert.isTrue((boostPower > 0 ? 1 : 0) != 0, (String)"Boost power must be positive!");
        this.boostPower = boostPower;
    }

    public void setRejectedPutBufferHandler(RejectedPutBufferHandler rejectedPutBufferHandler) {
        this.rejectedPutBufferHandler = rejectedPutBufferHandler;
    }

    public void setRejectedTakeBufferHandler(RejectedTakeBufferHandler rejectedTakeBufferHandler) {
        this.rejectedTakeBufferHandler = rejectedTakeBufferHandler;
    }

    public void setScheduleInterval(Long scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }
}

