/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.fsg.uid.utils;

import cn.hutool.core.util.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerUtils.class);
    private static final String ENV_KEY_HOST = "JPAAS_HOST";
    private static final String ENV_KEY_PORT = "JPAAS_HTTP_PORT";
    private static final String ENV_KEY_PORT_ORIGINAL = "JPAAS_HOST_PORT_8080";
    private static String DOCKER_HOST = "";
    private static String DOCKER_PORT = "";
    private static boolean IS_DOCKER;

    private DockerUtils() {
    }

    public static String getDockerHost() {
        return DOCKER_HOST;
    }

    public static String getDockerPort() {
        return DOCKER_PORT;
    }

    public static boolean isDocker() {
        return IS_DOCKER;
    }

    private static void retrieveFromEnv() {
        DOCKER_HOST = System.getenv(ENV_KEY_HOST);
        DOCKER_PORT = System.getenv(ENV_KEY_PORT);
        if (StrUtil.isBlank((CharSequence)DOCKER_PORT)) {
            DOCKER_PORT = System.getenv(ENV_KEY_PORT_ORIGINAL);
        }
        boolean hasEnvHost = StrUtil.isNotBlank((CharSequence)DOCKER_HOST);
        boolean hasEnvPort = StrUtil.isNotBlank((CharSequence)DOCKER_PORT);
        if (hasEnvHost && hasEnvPort) {
            IS_DOCKER = true;
        } else if (!hasEnvHost && !hasEnvPort) {
            IS_DOCKER = false;
        } else {
            LOGGER.error("Missing host or port from env for Docker. host:{}, port:{}", (Object)DOCKER_HOST, (Object)DOCKER_PORT);
            throw new RuntimeException("Missing host or port from env for Docker. host:" + DOCKER_HOST + ", port:" + DOCKER_PORT);
        }
    }

    static {
        DockerUtils.retrieveFromEnv();
    }
}

