/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.swagger2;

import cn.hutool.core.collection.CollUtil;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jProperties;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.customizers.GlobalOperationCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import top.tangyh.basic.swagger2.MyKnife4jOpenApiCustomizer;
import top.tangyh.basic.swagger2.Swagger2Configuration;
import top.tangyh.basic.swagger2.properties.SwaggerProperties;

@Import(value={Swagger2Configuration.class})
@ConditionalOnProperty(prefix="knife4j", name={"enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SwaggerProperties.class})
public class SwaggerAutoConfiguration {
    private final SwaggerProperties swaggerProperties;
    private final Knife4jProperties properties;

    public SwaggerAutoConfiguration(Knife4jProperties properties, SwaggerProperties swaggerProperties) {
        this.swaggerProperties = swaggerProperties;
        this.properties = properties;
    }

    @Bean
    public MyKnife4jOpenApiCustomizer knife4jOpenApiCustomizer(SpringDocConfigProperties docProperties) {
        return new MyKnife4jOpenApiCustomizer(this.properties, docProperties);
    }

    @Bean
    public GlobalOpenApiCustomizer orderGlobalOpenApiCustomizer() {
        return openApi -> {};
    }

    @Bean
    public GlobalOperationCustomizer customize2() {
        return (operation, handlerMethod) -> {
            List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters = this.swaggerProperties.getGlobalOperationParameters();
            if (CollUtil.isEmpty(globalOperationParameters)) {
                return operation;
            }
            for (SwaggerProperties.GlobalOperationParameter globalOperationParameter : globalOperationParameters) {
                operation = operation.addParametersItem(new Parameter().in(globalOperationParameter.getParameterType()).required(globalOperationParameter.getRequired()).schema((Schema)new StringSchema()).example((Object)globalOperationParameter.getDefaultValue()).description(globalOperationParameter.getDescription()).allowEmptyValue(globalOperationParameter.getAllowEmptyValue()).name(globalOperationParameter.getName()));
            }
            return operation;
        };
    }

    @Bean
    public OpenAPI customOpenApi() {
        return new OpenAPI().info(new Info().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).version(this.swaggerProperties.getVersion()).termsOfService(this.swaggerProperties.getTermsOfServiceUrl()).contact(new Contact().name(this.swaggerProperties.getContact().getName()).url(this.swaggerProperties.getContact().getUrl()).email(this.swaggerProperties.getContact().getEmail())).license(new License().name(this.swaggerProperties.getLicense()).url(this.swaggerProperties.getLicenseUrl())));
    }
}

