/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import top.tangyh.basic.annotation.log.SysLog;
import top.tangyh.basic.annotation.security.PreAuth;
import top.tangyh.basic.base.R;
import top.tangyh.basic.base.controller.PageController;
import top.tangyh.basic.base.request.PageParams;
import top.tangyh.basic.database.mybatis.conditions.Wraps;
import top.tangyh.basic.database.mybatis.conditions.query.QueryWrap;

public interface QueryController<Entity, Id extends Serializable, PageQuery>
extends PageController<Entity, PageQuery> {
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e", schema=@Schema(type="long"), in=ParameterIn.PATH)})
    @Operation(summary="\u5355\u4f53\u67e5\u8be2", description="\u5355\u4f53\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    @SysLog(value="'\u67e5\u8be2:' + #id")
    @PreAuth(value="hasAnyPermission('{}view')")
    default public R<Entity> get(@PathVariable Id id) {
        return this.success(this.getBaseService().getById((Serializable)id));
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/page"})
    @SysLog(value="'\u5206\u9875\u5217\u8868\u67e5\u8be2:\u7b2c' + #params?.current + '\u9875, \u663e\u793a' + #params?.size + '\u884c'", response=false)
    @PreAuth(value="hasAnyPermission('{}view')")
    default public R<IPage<Entity>> page(@RequestBody @Validated PageParams<PageQuery> params) {
        return this.success(this.query(params));
    }

    @Operation(summary="\u6279\u91cf\u67e5\u8be2", description="\u6279\u91cf\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @SysLog(value="\u6279\u91cf\u67e5\u8be2")
    @PreAuth(value="hasAnyPermission('{}view')")
    default public R<List<Entity>> query(@RequestBody Entity data) {
        QueryWrap wrapper = Wraps.q(data);
        return this.success(this.getBaseService().list((Wrapper)wrapper));
    }
}

