/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.log.aspect;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.servlet.ServletUtil;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.NonNull;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.tangyh.basic.annotation.log.SysLog;
import top.tangyh.basic.base.R;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.context.ThreadLocalParam;
import top.tangyh.basic.jackson.JsonUtil;
import top.tangyh.basic.log.entity.OptLogDTO;
import top.tangyh.basic.log.event.SysLogEvent;
import top.tangyh.basic.log.util.LogUtil;
import top.tangyh.basic.utils.SpringUtils;

@Aspect
public class SysLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SysLogAspect.class);
    public static final int MAX_LENGTH = 65535;
    private static final ThreadLocal<OptLogDTO> THREAD_LOCAL = new ThreadLocal();
    private static final String FORM_DATA_CONTENT_TYPE = "multipart/form-data";
    private final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    private final DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();

    @Pointcut(value="execution(public * top.tangyh.basic.base.controller.*.*(..)) || @annotation(top.tangyh.basic.annotation.log.SysLog)")
    public void sysLogAspect() {
    }

    @AfterReturning(returning="ret", pointcut="sysLogAspect()")
    public void doAfterReturning(JoinPoint joinPoint, Object ret) {
        this.tryCatch(p -> {
            SysLog sysLog = LogUtil.getTargetAnnotation(joinPoint);
            if (this.check(joinPoint, sysLog)) {
                return;
            }
            R r = (R)Convert.convert(R.class, (Object)ret);
            OptLogDTO sysLogDTO = this.get();
            if (r == null) {
                sysLogDTO.setType("OPT");
                if (sysLog.response()) {
                    sysLogDTO.setResult(this.getText(String.valueOf(ret == null ? "" : ret)));
                }
            } else {
                if (r.getIsSuccess().booleanValue()) {
                    sysLogDTO.setType("OPT");
                } else {
                    sysLogDTO.setType("EX");
                    sysLogDTO.setExDetail(r.getMsg());
                }
                if (sysLog.response()) {
                    sysLogDTO.setResult(this.getText(r.toString()));
                }
            }
            this.publishEvent(sysLogDTO);
        });
    }

    @AfterThrowing(pointcut="sysLogAspect()", throwing="e")
    public void doAfterThrowable(JoinPoint joinPoint, Throwable e) {
        this.tryCatch(aaa -> {
            SysLog sysLog = LogUtil.getTargetAnnotation(joinPoint);
            if (this.check(joinPoint, sysLog)) {
                return;
            }
            OptLogDTO optLogDTO = this.get();
            optLogDTO.setType("EX");
            if (!sysLog.request() && sysLog.requestByError() && StrUtil.isEmpty((CharSequence)optLogDTO.getParams())) {
                Object[] args = joinPoint.getArgs();
                HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
                String strArgs = this.getArgs(args, request);
                optLogDTO.setParams(this.getText(strArgs));
            }
            optLogDTO.setExDetail(ExceptionUtil.stacktraceToString((Throwable)e, (int)65535));
            this.publishEvent(optLogDTO);
        });
    }

    @Before(value="sysLogAspect()")
    public void doBefore(JoinPoint joinPoint) {
        this.tryCatch(val -> {
            SysLog sysLog = LogUtil.getTargetAnnotation(joinPoint);
            if (this.check(joinPoint, sysLog)) {
                return;
            }
            OptLogDTO optLogDTO = this.buildOptLogDTO(joinPoint, sysLog);
            THREAD_LOCAL.set(optLogDTO);
        });
    }

    @NonNull
    private OptLogDTO buildOptLogDTO(JoinPoint joinPoint, SysLog sysLog) {
        OptLogDTO optLogDTO = this.get();
        optLogDTO.setCreatedBy(ContextUtil.getUserId());
        optLogDTO.setUserName(ContextUtil.getName());
        this.setDescription(joinPoint, sysLog, optLogDTO);
        optLogDTO.setClassPath(joinPoint.getTarget().getClass().getName());
        optLogDTO.setActionMethod(joinPoint.getSignature().getName());
        HttpServletRequest request = this.setParams(joinPoint, sysLog, optLogDTO);
        optLogDTO.setRequestIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        optLogDTO.setRequestUri(URLUtil.getPath((String)request.getRequestURI()));
        optLogDTO.setHttpMethod(request.getMethod());
        optLogDTO.setUa(StrUtil.sub((CharSequence)request.getHeader("user-agent"), (int)0, (int)500));
        if (ContextUtil.getBoot().booleanValue()) {
            optLogDTO.setTenantCode(ContextUtil.getTenant());
            optLogDTO.setSubTenantCode(ContextUtil.getSubTenant());
        } else {
            optLogDTO.setTenantCode(request.getHeader("tenant"));
            optLogDTO.setSubTenantCode(request.getHeader("sub_tenant"));
        }
        optLogDTO.setTrace(MDC.get((String)"trace"));
        if (StrUtil.isEmpty((CharSequence)optLogDTO.getTrace())) {
            optLogDTO.setTrace(request.getHeader("x-trace-header"));
        }
        optLogDTO.setStartTime(LocalDateTime.now());
        return optLogDTO;
    }

    @NonNull
    private HttpServletRequest setParams(JoinPoint joinPoint, SysLog sysLog, OptLogDTO optLogDTO) {
        Object[] args = joinPoint.getArgs();
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes(), "\u53ea\u80fd\u5728Spring Web\u73af\u5883\u4f7f\u7528@SysLog\u8bb0\u5f55\u65e5\u5fd7")).getRequest();
        if (sysLog.request()) {
            String strArgs = this.getArgs(args, request);
            optLogDTO.setParams(this.getText(strArgs));
        }
        return request;
    }

    private void setDescription(JoinPoint joinPoint, SysLog sysLog, OptLogDTO optLogDTO) {
        String controllerMethodDescription;
        Object[] tags;
        Object controllerDescription = "";
        Api api = joinPoint.getTarget().getClass().getAnnotation(Api.class);
        if (api != null && ArrayUtil.isNotEmpty((Object[])(tags = api.tags()))) {
            controllerDescription = tags[0];
        }
        if (StrUtil.isNotEmpty((CharSequence)(controllerMethodDescription = LogUtil.getDescribe(sysLog))) && StrUtil.contains((CharSequence)controllerMethodDescription, (CharSequence)"#")) {
            Object[] args = joinPoint.getArgs();
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            controllerMethodDescription = this.getValBySpEl(controllerMethodDescription, methodSignature, args);
        }
        if (StrUtil.isEmpty((CharSequence)controllerDescription)) {
            optLogDTO.setDescription(controllerMethodDescription);
        } else if (sysLog.controllerApiValue()) {
            optLogDTO.setDescription((String)controllerDescription + "-" + controllerMethodDescription);
        } else {
            optLogDTO.setDescription(controllerMethodDescription);
        }
    }

    private OptLogDTO get() {
        OptLogDTO sysLog = THREAD_LOCAL.get();
        if (sysLog == null) {
            return new OptLogDTO();
        }
        return sysLog;
    }

    private void tryCatch(Consumer<String> consumer) {
        try {
            consumer.accept("");
        }
        catch (Exception e) {
            log.warn("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
            THREAD_LOCAL.remove();
        }
    }

    private void publishEvent(OptLogDTO sysLog) {
        sysLog.setFinishTime(LocalDateTime.now());
        sysLog.setConsumingTime(Long.valueOf(sysLog.getStartTime().until(sysLog.getFinishTime(), ChronoUnit.MILLIS)));
        SpringUtils.publishEvent((Object)((Object)new SysLogEvent(sysLog)));
        THREAD_LOCAL.remove();
    }

    private boolean check(JoinPoint joinPoint, SysLog sysLog) {
        if (sysLog == null || !sysLog.enabled()) {
            return true;
        }
        SysLog targetClass = joinPoint.getTarget().getClass().getAnnotation(SysLog.class);
        return targetClass != null && !targetClass.enabled();
    }

    private String getText(String val) {
        return StrUtil.sub((CharSequence)val, (int)0, (int)65535);
    }

    private String getArgs(Object[] args, HttpServletRequest request) {
        String strArgs = "";
        Object[] params = Arrays.stream(args).filter(item -> !(item instanceof ServletRequest) && !(item instanceof ServletResponse)).toArray();
        try {
            if (!request.getContentType().contains(FORM_DATA_CONTENT_TYPE)) {
                strArgs = JsonUtil.toJson((Object)params);
            }
        }
        catch (Exception e) {
            try {
                strArgs = Arrays.toString(params);
            }
            catch (Exception ex) {
                log.warn("\u89e3\u6790\u53c2\u6570\u5f02\u5e38", (Throwable)ex);
            }
        }
        return strArgs;
    }

    private String getValBySpEl(String spEl, MethodSignature methodSignature, Object[] args) {
        try {
            String[] paramNames = this.nameDiscoverer.getParameterNames(methodSignature.getMethod());
            if (paramNames != null && paramNames.length > 0) {
                Expression expression = this.spelExpressionParser.parseExpression(spEl);
                StandardEvaluationContext context = new StandardEvaluationContext();
                for (int i = 0; i < args.length; ++i) {
                    context.setVariable(paramNames[i], args[i]);
                    context.setVariable("p" + i, args[i]);
                }
                ThreadLocalParam tlp = new ThreadLocalParam();
                BeanUtil.fillBeanWithMap((Map)ContextUtil.getLocalMap(), (Object)tlp, (boolean)true);
                context.setVariable("threadLocal", (Object)tlp);
                Object value = expression.getValue((EvaluationContext)context);
                return value == null ? spEl : value.toString();
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u64cd\u4f5c\u65e5\u5fd7\u7684el\u8868\u8fbe\u5f0f\u51fa\u9519", (Throwable)e);
        }
        return spEl;
    }
}

