/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.log;

import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import top.tangyh.basic.jackson.JsonUtil;
import top.tangyh.basic.log.aspect.SysLogAspect;
import top.tangyh.basic.log.event.SysLogListener;
import top.tangyh.basic.log.monitor.PointUtil;

@EnableAsync
@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="lamp.log", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LogAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SysLogAspect sysLogAspect() {
        return new SysLogAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="${lamp.log.enabled:true} && 'LOGGER'.equals('${lamp.log.type:LOGGER}')")
    public SysLogListener sysLogListener() {
        return new SysLogListener(log -> PointUtil.debug("0", "OPT_LOG", JsonUtil.toJson((Object)log)));
    }
}

