/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.jwt.utils;

import cn.hutool.core.util.StrUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.SignatureException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.exception.BizException;
import top.tangyh.basic.exception.code.BaseExceptionCode;
import top.tangyh.basic.exception.code.ExceptionCode;
import top.tangyh.basic.jwt.model.Token;
import top.tangyh.basic.utils.DateUtils;

public final class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    private static final String BASE64_SECURITY = Base64.getEncoder().encodeToString("lamp-cloud_is_a_fantastic_project".getBytes(StandardCharsets.UTF_8));

    private JwtUtil() {
    }

    public static String[] getClient(String basicHeader) {
        if (StrUtil.isEmpty((CharSequence)basicHeader) || !basicHeader.startsWith("Basic ")) {
            throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_BASIC_INVALID);
        }
        String decodeBasic = StrUtil.subAfter((CharSequence)basicHeader, (CharSequence)"Basic ", (boolean)false);
        return JwtUtil.extractClient(decodeBasic);
    }

    public static String[] extractClient(String client) {
        String token = JwtUtil.base64Decoder(client);
        int index = token.indexOf(":");
        if (index == -1) {
            throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_BASIC_INVALID);
        }
        return new String[]{token.substring(0, index), token.substring(index + 1)};
    }

    public static String base64Decoder(String val) {
        byte[] decoded = Base64.getDecoder().decode(val.getBytes(StandardCharsets.UTF_8));
        return new String(decoded, StandardCharsets.UTF_8);
    }

    public static Token createJwt(Map<String, String> user, long expire) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = Base64.getDecoder().decode(BASE64_SECURITY);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"JsonWebToken");
        user.forEach((arg_0, arg_1) -> ((JwtBuilder)builder).claim(arg_0, arg_1));
        long expMillis = nowMillis + expire * 1000L;
        Date exp = new Date(expMillis);
        builder.setIssuedAt(now).setNotBefore(now).setExpiration(exp).signWith((Key)signingKey, signatureAlgorithm);
        Token tokenInfo = new Token();
        tokenInfo.setToken(builder.compact());
        tokenInfo.setExpire(expire);
        tokenInfo.setExpiration(DateUtils.date2LocalDateTime((Date)exp));
        return tokenInfo;
    }

    public static Claims parseJwt(String jsonWebToken, long allowedClockSkewSeconds) {
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey(Base64.getDecoder().decode(BASE64_SECURITY)).setAllowedClockSkewSeconds(allowedClockSkewSeconds).build().parseClaimsJws(jsonWebToken).getBody();
        }
        catch (ExpiredJwtException ex) {
            log.error("token=[{}], \u8fc7\u671f", (Object)jsonWebToken, (Object)ex);
            throw new BizException(ExceptionCode.JWT_TOKEN_EXPIRED.getCode(), ExceptionCode.JWT_TOKEN_EXPIRED.getMsg(), (Throwable)ex);
        }
        catch (SignatureException ex) {
            log.error("token=[{}] \u7b7e\u540d\u9519\u8bef", (Object)jsonWebToken, (Object)ex);
            throw new BizException(ExceptionCode.JWT_SIGNATURE.getCode(), ExceptionCode.JWT_SIGNATURE.getMsg(), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            log.error("token=[{}] \u4e3a\u7a7a", (Object)jsonWebToken, (Object)ex);
            throw new BizException(ExceptionCode.JWT_ILLEGAL_ARGUMENT.getCode(), ExceptionCode.JWT_ILLEGAL_ARGUMENT.getMsg(), (Throwable)ex);
        }
        catch (Exception e) {
            log.error("token=[{}] errCode:{}, message:{}", new Object[]{jsonWebToken, ExceptionCode.JWT_PARSER_TOKEN_FAIL.getCode(), e.getMessage(), e});
            throw new BizException(ExceptionCode.JWT_PARSER_TOKEN_FAIL.getCode(), ExceptionCode.JWT_PARSER_TOKEN_FAIL.getMsg(), (Throwable)e);
        }
    }

    public static String getToken(String token) {
        if (token == null) {
            throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_PARSER_TOKEN_FAIL);
        }
        if (token.startsWith("Bearer ")) {
            return StrUtil.subAfter((CharSequence)token, (CharSequence)"Bearer ", (boolean)false);
        }
        log.info("jsonWebToken={}", (Object)token);
        throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_PARSER_TOKEN_FAIL);
    }

    public static Claims getClaims(String token, long allowedClockSkewSeconds) {
        if (token == null) {
            throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_PARSER_TOKEN_FAIL);
        }
        if (token.startsWith("Bearer ")) {
            String headStr = StrUtil.subAfter((CharSequence)token, (CharSequence)"Bearer ", (boolean)false);
            return JwtUtil.parseJwt(headStr, allowedClockSkewSeconds);
        }
        log.info("jsonWebToken={}", (Object)token);
        throw BizException.wrap((BaseExceptionCode)ExceptionCode.JWT_PARSER_TOKEN_FAIL);
    }
}

