/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.echo.core;

import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import top.tangyh.basic.echo.manager.CacheLoadKeys;
import top.tangyh.basic.echo.properties.EchoProperties;

public class DefCacheLoader
extends CacheLoader<CacheLoadKeys, Map<Serializable, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefCacheLoader.class);
    private final ListeningExecutorService backgroundRefreshPools;

    public DefCacheLoader(EchoProperties.GuavaCache guavaCache) {
        this.backgroundRefreshPools = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(guavaCache.getRefreshThreadPoolSize(), guavaCache.getRefreshThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public Map<Serializable, Object> load(@NonNull CacheLoadKeys type) {
        log.info("\u9996\u6b21\u8bfb\u53d6\u7f13\u5b58: " + type);
        return type.loadMap();
    }

    public ListenableFuture<Map<Serializable, Object>> reload(@NonNull CacheLoadKeys key, @NonNull Map<Serializable, Object> oldValue) {
        return this.backgroundRefreshPools.submit(() -> this.load(key));
    }
}

